/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.plugin.vault;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.xebialabs.deployit.engine.spi.exception.DeployitException;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.util.PasswordEncrypter;
import com.xebialabs.xlrelease.domain.ExternalVariableServer;
import com.xebialabs.xlrelease.domain.variables.ExternalVariableValue;
import com.xebialabs.xlrelease.domain.variables.PasswordStringVariable;
import com.xebialabs.xlrelease.plugin.vault.ExternalVariableResolutionFailedException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;
import org.springframework.vault.authentication.SimpleSessionManager;
import org.springframework.vault.authentication.TokenAuthentication;
import org.springframework.vault.client.RestTemplateBuilder;
import org.springframework.vault.client.VaultEndpoint;
import org.springframework.vault.core.VaultTemplate;
import org.springframework.vault.support.VaultMount;
import org.springframework.vault.support.VaultResponse;

@Metadata(label="Vault Server")
public class VaultServer
extends ExternalVariableServer {
    private static final String DATA = "data";
    private static final String METADATA = "metadata";
    private static final String VERSION = "version";
    private static final String TYPE_KV = "kv";
    private static final Logger logger = LoggerFactory.getLogger(VaultServer.class);
    @Property(description="AuthenticationMethod DependentProperties", required=false, hidden=true, defaultValue="PAT:token,Basic:username;password,Approle:role_id;secret_id,LDAP:username;password", category="Authentication")
    private Map<String, String> authenticationMethod_DependentProperties;
    @Property(label="Authentication Method", required=false, defaultValue="PAT")
    private AuthenticationMethod authenticationMethod;
    @Property(description="Script Location", required=false, hidden=true, defaultValue="vault/CheckConnection.py")
    private String scriptLocation;
    @Property(description="See https://www.vaultproject.io/docs/enterprise/namespaces", defaultValue="", required=false, category="Enterprise")
    private String namespace;
    @Property(required=false, description="Login user ID on the server", category="Authentication")
    private String username;
    @Property(password=true, required=false, description="Login user password on the server", category="Authentication")
    private String password;
    @Property(required=false, description="Roleid of the AppRole", category="Authentication")
    private String role_id;
    @Property(password=false, required=false, description="Secretid of the AppRole", category="Authentication")
    private String secret_id;

    public String getRole_id() {
        return this.role_id;
    }

    public void setRole_id(String role_id) {
        this.role_id = role_id;
    }

    public String getSecret_id() {
        return this.secret_id;
    }

    public void setSecret_id(String secret_id) {
        this.secret_id = secret_id;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getScriptLocation() {
        return this.scriptLocation;
    }

    public void setScriptLocation(String scriptLocation) {
        this.scriptLocation = scriptLocation;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public Map<String, String> getAuthenticationMethod_DependentProperties() {
        return this.authenticationMethod_DependentProperties;
    }

    public void setAuthenticationMethod_DependentProperties(Map<String, String> authenticationMethod_DependentProperties) {
        this.authenticationMethod_DependentProperties = authenticationMethod_DependentProperties;
    }

    public AuthenticationMethod getAuthenticationMethod() {
        return this.authenticationMethod;
    }

    public void setAuthenticationMethod(AuthenticationMethod authenticationMethod) {
        this.authenticationMethod = authenticationMethod;
    }

    public VaultTemplate createConnection() {
        String url = this.getUrl();
        boolean isPat = false;
        VaultEndpoint vaultEndpoint = VaultEndpoint.from(URI.create(url));
        if (this.getAuthenticationMethod().toString() == "PAT") {
            isPat = true;
            TokenAuthentication clientAuthentication = new TokenAuthentication(PasswordEncrypter.getInstance().ensureDecrypted(this.getToken()));
            return this.getVaulTemplateWithClientAuthentication(clientAuthentication, vaultEndpoint, true);
        }
        String jsonString = this.getRequestData("password", PasswordEncrypter.getInstance().ensureDecrypted(this.getPassword()), Boolean.FALSE);
        String urlwithusername = this.getRequestUrl(url, "v1/auth/userpass/login/", this.getUsername());
        if (this.getAuthenticationMethod().toString() == "LDAP") {
            urlwithusername = this.getRequestUrl(url, "v1/auth/ldap/login/", this.getUsername());
        }
        if (this.getAuthenticationMethod().toString() == "Approle") {
            urlwithusername = this.getRequestUrl(url, "v1/auth/approle/login", "");
            jsonString = this.getRequestData(this.getRole_id(), this.getSecret_id(), Boolean.TRUE);
        }
        HttpResponse<String> response = this.executeApiRequest(urlwithusername, jsonString, "POST");
        this.setToken(this.parseResponse(response.body().toString()));
        TokenAuthentication clientAuthentication = new TokenAuthentication(this.getToken());
        return this.getVaulTemplateWithClientAuthentication(clientAuthentication, vaultEndpoint, false);
    }

    public VaultTemplate getVaulTemplateWithClientAuthentication(TokenAuthentication clientAuthentication, VaultEndpoint vaultEndpoint, boolean isPat) {
        RestTemplateBuilder restTemplateBuilder = RestTemplateBuilder.builder().endpoint(vaultEndpoint);
        if (!isPat) {
            restTemplateBuilder.defaultHeader("X-Vault-Token", this.getToken());
        }
        VaultTemplate vaultTemplate = this.namespace != null && !this.namespace.isEmpty() ? new VaultTemplate(restTemplateBuilder.defaultHeader("X-Vault-Namespace", this.namespace), new SimpleSessionManager(clientAuthentication)) : new VaultTemplate(restTemplateBuilder, new SimpleSessionManager(clientAuthentication));
        return vaultTemplate;
    }

    public void revokeIfUserpassToken() {
        if (this.getAuthenticationMethod() == AuthenticationMethod.Basic || this.getAuthenticationMethod() == AuthenticationMethod.LDAP || this.getAuthenticationMethod() == AuthenticationMethod.Approle) {
            String urlfortokenrevoke = this.getRequestUrl(this.getUrl(), "v1/auth/token/revoke", "");
            String jsonString = this.getRequestData("token", this.getToken(), Boolean.FALSE);
            HttpResponse<String> httpResponse = this.executeApiRequest(urlfortokenrevoke, jsonString, "POST");
        }
    }

    public HttpResponse<String> executeApiRequest(String url, String data, String method) {
        HttpClient client = HttpClient.newHttpClient();
        String tokenAvailable = "";
        if (this.getToken() != null && this.getToken().length() > 0) {
            tokenAvailable = this.getToken();
        }
        HttpRequest request = HttpRequest.newBuilder(URI.create(url)).header("accept", "application/json").header("X-Vault-Token", tokenAvailable).POST(HttpRequest.BodyPublishers.ofString(data)).build();
        try {
            HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
            return response;
        }
        catch (Exception e) {
            logger.error("An error occurred when request is executed", (Throwable)e);
            return null;
        }
    }

    public String parseResponse(String jsonData) {
        try {
            ObjectMapper obj = new ObjectMapper();
            JsonFactory factory = obj.getFactory();
            JsonParser parser = factory.createParser(jsonData);
            JsonNode node = (JsonNode)obj.readTree(parser);
            JsonNode node1 = node.get("auth");
            JsonNode node2 = node1.get("client_token");
            return node2.textValue();
        }
        catch (Exception e) {
            logger.error("An error occurred when response is parsed", (Throwable)e);
            return "";
        }
    }

    public String getRequestData(String key, String value, Boolean isApprole) {
        String jsonString = "";
        try {
            ObjectMapper mapper = new ObjectMapper();
            ObjectNode rootNode = mapper.createObjectNode();
            if (isApprole.booleanValue()) {
                rootNode.put("role_id", key);
                rootNode.put("secret_id", value);
            } else {
                rootNode.put(key, value);
            }
            jsonString = mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)rootNode);
            return jsonString;
        }
        catch (Exception e) {
            logger.error("An error occurred when request is executed", (Throwable)e);
            return jsonString;
        }
    }

    public String getRequestUrl(String loginurl, String path, String username) {
        Object urlwithusername = "";
        urlwithusername = loginurl.endsWith("/") ? loginurl + path + username : loginurl + "/" + path + username;
        return urlwithusername;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkConnection() {
        VaultTemplate vaultTemplate = null;
        try {
            vaultTemplate = this.createConnection();
            vaultTemplate.read("/");
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            logger.error("An error occurred when checking connection for Vault: ", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (vaultTemplate != null) {
                    vaultTemplate.destroy();
                    this.revokeIfUserpassToken();
                }
            }
            catch (Exception e) {
                logger.error("An error occurred when closing connection for Vault: ", (Throwable)e);
            }
        }
    }

    private Map.Entry<String, VaultMount> getVaultMount(String path, Map<String, VaultMount> allMounts) {
        for (Map.Entry<String, VaultMount> entry : allMounts.entrySet()) {
            if (!path.startsWith(entry.getKey())) continue;
            return entry;
        }
        throw new ExternalVariableResolutionFailedException("No mount found for path '%s' in Vault server %s.", path, this.getUrl());
    }

    private String getVersion(VaultMount details) {
        Map<String, String> options;
        String type;
        String version = null;
        if (details != null && (type = details.getType()) != null && type.equals(TYPE_KV) && (options = details.getOptions()) != null) {
            return options.get(VERSION);
        }
        return version;
    }

    private String getPath(String path, Map<String, VaultMount> allMounts) {
        String subPath;
        if (((String)path).startsWith("/")) {
            path = StringUtils.trimLeadingCharacter((String)path, (char)'/');
        }
        Map.Entry<String, VaultMount> entry = this.getVaultMount((String)path, allMounts);
        String mount = entry.getKey();
        String version = this.getVersion(entry.getValue());
        if (version != null && version.equals("2") && !(subPath = ((String)path).substring(mount.length())).startsWith("data/")) {
            path = mount + "data/" + subPath;
        }
        return path;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Map<String, String> lookup(List<PasswordStringVariable> variables) {
        HashMap<String, String> lookupMap = new HashMap<String, String>();
        VaultTemplate vaultTemplate = this.createConnection();
        Map<String, VaultMount> mounts = vaultTemplate.opsForSys().getMounts();
        String externalKey = "";
        String path = "";
        try {
            for (PasswordStringVariable var : variables) {
                ExternalVariableValue externalVariableValue = var.getExternalVariableValue();
                externalKey = externalVariableValue.getExternalKey();
                path = this.getPath(externalVariableValue.getPath(), mounts);
                VaultResponse response = this.assertNotNull(vaultTemplate.read(path), "Path not found.", new Object[0]);
                Map<String, Object> data = this.assertNotNull(this.getResponseData(response), "Cannot find data is response from path.", new Object[0]);
                Object retrievedValue = this.assertNotNull(data.get(externalKey), "Key not found.", new Object[0]);
                lookupMap.put(var.getKey(), retrievedValue.toString());
            }
        }
        catch (ExternalVariableResolutionFailedException e) {
            try {
                throw e;
                catch (Throwable t) {
                    throw new ExternalVariableResolutionFailedException("Unable to lookup path '%s' and key '%s' in Vault server %s; reason: %s", path, externalKey, this.getUrl(), t.getMessage());
                }
            }
            catch (Throwable throwable) {
                try {
                    vaultTemplate.destroy();
                    this.revokeIfUserpassToken();
                    throw throwable;
                }
                catch (Exception e2) {
                    logger.error(String.format("Unable to close the vault endpoint to [%s]", this.getUrl()), (Throwable)e2);
                }
                throw throwable;
            }
        }
        try {
            vaultTemplate.destroy();
            this.revokeIfUserpassToken();
            return lookupMap;
        }
        catch (Exception e) {
            logger.error(String.format("Unable to close the vault endpoint to [%s]", this.getUrl()), (Throwable)e);
            return lookupMap;
        }
    }

    @Nullable
    private Map<String, Object> getResponseData(VaultResponse response) {
        Map data = (Map)response.getData();
        if (data == null) {
            return null;
        }
        if (!data.containsKey(METADATA)) {
            return data;
        }
        return (Map)data.get(DATA);
    }

    private <T> T assertNotNull(T object, String message, Object ... args) {
        if (object != null) {
            return object;
        }
        throw new DeployitException(message, args);
    }

    public static enum AuthenticationMethod {
        Basic,
        PAT,
        Approle,
        LDAP;

    }
}

