/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import org.apache.derby.iapi.services.loader.GeneratedMethod;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.sql.execute.NoPutResultSet;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.impl.sql.execute.JoinResultSet;
import org.apache.derby.shared.common.error.StandardException;

class NestedLoopJoinResultSet
extends JoinResultSet {
    private boolean returnedRowMatchingRightSide = false;
    private ExecRow rightTemplate;

    @Override
    void clearScanState() {
        this.returnedRowMatchingRightSide = false;
        super.clearScanState();
    }

    @Override
    public ExecRow getNextRowCore() throws StandardException {
        if (this.isXplainOnlyMode()) {
            return null;
        }
        ExecRow execRow = null;
        boolean bl = false;
        boolean bl2 = false;
        this.beginTime = this.getCurrentTimeMillis();
        if (!this.isOpen) {
            throw StandardException.newException((String)"XCL16.S", (Object[])new Object[]{"next"});
        }
        if (!this.isRightOpen && this.leftRow != null) {
            this.leftRow = this.leftResultSet.getNextRowCore();
            if (this.leftRow == null) {
                this.closeRight();
            } else {
                ++this.rowsSeenLeft;
                this.openRight();
            }
        }
        while (this.leftRow != null && !bl) {
            DataValueDescriptor dataValueDescriptor;
            if (this.oneRowRightSide && this.returnedRowMatchingRightSide) {
                this.rightRow = null;
                this.returnedRowMatchingRightSide = false;
            } else {
                this.rightRow = this.rightResultSet.getNextRowCore();
                if (this.notExistsRightSide) {
                    this.rightRow = this.rightRow == null ? this.rightTemplate : null;
                }
                boolean bl3 = this.returnedRowMatchingRightSide = this.rightRow != null;
            }
            if (this.rightRow == null) {
                this.leftRow = this.leftResultSet.getNextRowCore();
                if (this.leftRow == null) {
                    this.closeRight();
                    continue;
                }
                ++this.rowsSeenLeft;
                this.openRight();
                continue;
            }
            ++this.rowsSeenRight;
            if (this.restriction != null) {
                DataValueDescriptor dataValueDescriptor2 = (DataValueDescriptor)this.restriction.invoke(this.activation);
                boolean bl4 = bl2 = !dataValueDescriptor2.isNull() && dataValueDescriptor2.getBoolean();
                if (!bl2) {
                    ++this.rowsFiltered;
                    continue;
                }
            }
            if (this.mergedRow == null) {
                this.mergedRow = this.getExecutionFactory().getValueRow(this.leftNumCols + this.rightNumCols);
            }
            int n = 1;
            int n2 = 1;
            while (n <= this.leftNumCols) {
                dataValueDescriptor = this.leftRow.getColumn(n);
                if (dataValueDescriptor != null && dataValueDescriptor.hasStream()) {
                    dataValueDescriptor = dataValueDescriptor.cloneValue(false);
                }
                this.mergedRow.setColumn(n2, dataValueDescriptor);
                ++n;
                ++n2;
            }
            if (!this.notExistsRightSide) {
                n = 1;
                while (n <= this.rightNumCols) {
                    dataValueDescriptor = this.rightRow.getColumn(n);
                    if (dataValueDescriptor != null && dataValueDescriptor.hasStream()) {
                        dataValueDescriptor = dataValueDescriptor.cloneValue(false);
                    }
                    this.mergedRow.setColumn(n2, dataValueDescriptor);
                    ++n;
                    ++n2;
                }
            }
            this.setCurrentRow(this.mergedRow);
            bl = true;
        }
        if (bl) {
            execRow = this.mergedRow;
            ++this.rowsReturned;
        } else {
            this.clearCurrentRow();
        }
        this.nextTime += this.getElapsedMillis(this.beginTime);
        return execRow;
    }

    @Override
    public void close() throws StandardException {
        if (this.isOpen) {
            this.beginTime = this.getCurrentTimeMillis();
            this.clearCurrentRow();
            super.close();
            this.returnedRowMatchingRightSide = false;
            this.closeTime += this.getElapsedMillis(this.beginTime);
        }
    }

    @Override
    public long getTimeSpent(int n) {
        long l = this.constructorTime + this.openTime + this.nextTime + this.closeTime;
        if (n == 0) {
            return l - this.leftResultSet.getTimeSpent(1) - this.rightResultSet.getTimeSpent(1);
        }
        return l;
    }

    NestedLoopJoinResultSet(NoPutResultSet noPutResultSet, int n, NoPutResultSet noPutResultSet2, int n2, Activation activation, GeneratedMethod generatedMethod, int n3, boolean bl, boolean bl2, double d, double d2, String string) {
        super(noPutResultSet, n, noPutResultSet2, n2, activation, generatedMethod, n3, bl, bl2, d, d2, string);
        if (bl2) {
            this.rightTemplate = this.getExecutionFactory().getValueRow(n2);
        }
    }
}

