/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.activity;

public class DurationFormatter {
    static final int ONE_MINUTE = 60;
    static final int ONE_HOUR = 3600;
    static final int ONE_DAY = 86400;

    private DurationFormatter() {
    }

    public static String formatDuration(Integer duration) {
        Object formatted;
        if (duration == null) {
            return "";
        }
        int durationInMin = (int)Math.round((double)duration.intValue() / 60.0);
        int durationInHour = durationInMin / 60;
        int durationInDay = durationInHour / 24;
        if (durationInMin == 0 && durationInHour == 0 && durationInDay == 0) {
            return "0 days";
        }
        int hours = durationInHour % 24;
        int minutes = durationInMin % 60;
        Object object = formatted = durationInDay != 0 ? durationInDay + " days" : "";
        if (hours != 0 || minutes != 0) {
            formatted = (String)formatted + " " + DurationFormatter.twoDigit(hours) + ":" + DurationFormatter.twoDigit(minutes);
        }
        return ((String)formatted).trim();
    }

    private static String twoDigit(int number) {
        return String.format("%02d", number);
    }
}

