/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plumbing.authentication;

import com.xebialabs.xlrelease.domain.UserProfile;
import com.xebialabs.xlrelease.security.XLReleasePermissions;
import com.xebialabs.xlrelease.security.authentication.RunnerAuthenticationToken;
import com.xebialabs.xlrelease.service.UserLastActiveActorService;
import com.xebialabs.xlrelease.service.UserProfileService;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.access.AccessDecisionVoter;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.oauth2.client.authentication.OAuth2AuthenticationToken;

public class LoginPermissionVoter
implements AccessDecisionVoter<Object> {
    private static final Logger logger = LoggerFactory.getLogger(LoginPermissionVoter.class);
    private final UserProfileService userProfileService;
    private final UserLastActiveActorService userLastActiveActorService;

    public LoginPermissionVoter(UserProfileService userProfileService, UserLastActiveActorService userLastActiveActorService) {
        this.userProfileService = userProfileService;
        this.userLastActiveActorService = userLastActiveActorService;
    }

    public boolean supports(ConfigAttribute attribute) {
        return true;
    }

    public boolean supports(Class<?> clazz) {
        return true;
    }

    public int vote(Authentication authentication, Object object, Collection<ConfigAttribute> attributes) {
        String username = authentication.getName();
        logger.debug("Checking login permission for [{}]", (Object)username);
        if (authentication instanceof RunnerAuthenticationToken) {
            return 1;
        }
        if (XLReleasePermissions.isAdmin((String)username)) {
            this.userLastActiveActorService.updateLastActive("admin");
            return 1;
        }
        UserProfile userProfile = this.userProfileService.findByUsername(username);
        if (userProfile != null && userProfile.isLoginAllowed()) {
            logger.debug("User [{}] is authorized for login", (Object)username);
            this.onAccessGranted(authentication, userProfile);
            return 1;
        }
        logger.error("User [{}] is not authorized for login", (Object)username);
        return -1;
    }

    private void onAccessGranted(Authentication authentication, UserProfile userProfile) {
        this.userLastActiveActorService.updateLastActive(userProfile.getCanonicalId());
        Object details = authentication.getDetails();
        String realUserName = userProfile.getName();
        Collection oldAuthorities = authentication.getAuthorities();
        SimpleGrantedAuthority authenticatedUserAuthority = new SimpleGrantedAuthority("authenticated-user");
        Collection newAuthorities = oldAuthorities;
        if (!oldAuthorities.contains(authenticatedUserAuthority)) {
            HashSet<Object> modifiableAuthorities = new HashSet<Object>();
            modifiableAuthorities.add(authenticatedUserAuthority);
            modifiableAuthorities.addAll(oldAuthorities);
            newAuthorities = Collections.unmodifiableCollection(modifiableAuthorities);
        }
        if (authentication instanceof OAuth2AuthenticationToken) {
            OAuth2AuthenticationToken oldToken = (OAuth2AuthenticationToken)authentication;
            OAuth2AuthenticationToken newAuthentication = new OAuth2AuthenticationToken(oldToken.getPrincipal(), newAuthorities, oldToken.getAuthorizedClientRegistrationId());
            SecurityContextHolder.getContext().setAuthentication((Authentication)newAuthentication);
            return;
        }
        UsernamePasswordAuthenticationToken token = new UsernamePasswordAuthenticationToken((Object)realUserName, authentication.getCredentials(), newAuthorities);
        token.setDetails(details);
        SecurityContextHolder.getContext().setAuthentication((Authentication)token);
    }
}

