#
# Copyright (c) 2020. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries, and licensors.
#

import hvac
import requests
import json
from com.xebialabs.xlrelease.plugin.vault import VaultServer

class VaultClient(object):
    # TODO: Consider adding support for headers
    # TODO: Consider adding support for namespace
    # TODO: Consider adding support for TTL
    # TODO: May need to consider adding/handling redirects (allow_redirects)

    # It is convenient to have separate values for exit codes, instead of the usual exit(1)
    VAULT_SERVER_SEALED = 1
    VAULT_NOT_AUTHENTICATED = 2
    VAULT_NO_TOKEN = 3
    VAULT_NO_SERVER_PROVIDED = 4
    VAULT_NOT_INITIALIZED = 5

    def __init__(self, url, token=None, username=None, password=None, logger=None, namespace=None, authenticationMethod=None, role_id=None, secret_id=None):
        self.logger = logger
        self.logger.info("=== VAULT START INITIALIZE ===")
        self.host = url
        if not self.host.endswith("/"):
            self.host = "%s/" % self.host
        self.authenticationMethod = authenticationMethod
        if self.host is None:
            self.exit(self.VAULT_NO_SERVER_PROVIDED, "No Server was provided")
        if str(self.authenticationMethod) != "PAT":
            self.username = username
            self.password = password
            self.namespace = namespace
            self.role_id = role_id
            self.secret_id = secret_id
            if self.password is not None and self.username is not None:
                passworddict = {'password': self.password}
                app_json = json.dumps(passworddict)
                self.urlwithusername = self.host+'v1/auth/userpass/login/'+self.username
            if str(self.authenticationMethod) == str(VaultServer.AuthenticationMethod.LDAP):
                self.urlwithusername = self.host+'v1/auth/ldap/login/'+self.username
            elif str(self.authenticationMethod) == str(VaultServer.AuthenticationMethod.Approle):
                self.urlwithusername = self.host+'v1/auth/approle/login'
                appRoledict = {'role_id': self.role_id,'secret_id': self.secret_id}
                app_json = json.dumps(appRoledict)
            response = requests.post(url=self.urlwithusername, data = app_json, verify=False)
            responseload = response.json()
            if not response.ok:
                raise Exception("Unable to get User Token")
            else:
                self.usertoken = responseload['auth']['client_token']
                self.client = hvac.Client(url=self.host, token=self.usertoken,allow_redirects=False, verify=False,
                                          namespace=self.namespace)
        elif str(self.authenticationMethod) == "PAT":
            self.token = token
            self.namespace = namespace
            self.client = hvac.Client(url=self.host, token=self.token,allow_redirects=False, verify=False,
                                      namespace=self.namespace)
        else:
            exit("VAULT ({}) {}".format(self.VAULT_NO_TOKEN, "No Token or Username/Password/role_id-secret_id provided"))

        self.logger.info("=== VAULT END INITIALIZE ===")

    @staticmethod
    def exit (code, message, authenticationType=None):
        print ("Exit", message)
        if authenticationType is not None:
            if authenticationType is VaultServer.AuthenticationMethod.Basic or authenticationType is VaultClient.AuthenticationMethod.LDAP or authenticationType is VaultClient.AuthenticationMethod.Approle:
                VaultClient.revokeUserPassToken()
        exit("VAULT ({}) {}".format(code, message))

    def revokeUserPassToken(self):
        tokendict = {'token': self.usertoken}
        headersdict = {'X-Vault-Token': self.usertoken}
        app_json = json.dumps(tokendict)
        self.urlRevoke = self.host+'v1/auth/token/revoke'
        response = requests.post(url=self.urlRevoke, data=app_json, headers=headersdict, verify=False)

    # TODO: I am not sure we need this.  The operation is simple and we can inline the conditional elsewhere.
    def get_init(self):
        if (self.client.sys.is_initialized()):
            self.logger.info('Vault is initialized at %', url)
            return data
        else:
            VaultClient.exit(Vault.VAULT_NOT_INITIALIZED, "Vault is not initialized at {}".format(url), authenticationType=str(self.authenticationMethod))
