#
# Copyright (c) 2020. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries, and licensors.
#

import time, sys, datetime
from com.versionone.apiclient import V1Connector
from com.versionone.apiclient import Services
from com.versionone.apiclient import Asset
from com.versionone.apiclient import Query

from versionone import convert_to_datetime
from versionone.VersionOneClient import VersionOneClient

global versionOneServer

if versionOneServer is None:
    print("No VersionOne server provided.")
    sys.exit(1)

if versionOneServer['accessToken']:
    connector = V1Connector.withInstanceUrl(versionOneServer['url']).withUserAgentHeader("XL Release", str(time.time())).withAccessToken(versionOneServer['accessToken']).build()
else:
    connector = V1Connector.withInstanceUrl(versionOneServer['url']).withUserAgentHeader("XL Release", str(time.time())).withUsernameAndPassword(versionOneServer['username'], versionOneServer['password']).build()

services = Services(connector)
asset_type = services.getMeta().getAssetType(assetType)

# Getting asset template response
v1Client = VersionOneClient.create_v1Client(versionOneServer)
whereClause="Number='%s'" % assetTemplateId
results = v1Client.getAssetTemplate(assetType, whereClause)
asset = results['Assets'][0]
assetId = asset['id']
data = {}

# Generating asset from asset template
operation_type = asset_type.getOperation("Copy")
asset_template_oid = services.getOid(assetId)
new_asset_oid = services.executeOperation(operation_type, asset_template_oid)
print("Successfully generated new asset. Asset OID=%s") % new_asset_oid
new_asset = Asset(new_asset_oid)

# Updating asset details
for key, value in attributes.iteritems():
    print("key=%s, value=%s") %(key, value)
    name_attribute = asset_type.getAttributeDefinition(key)
    new_asset.setAttributeValue(name_attribute, value)
services.save(new_asset)

_query = Query(new_asset.getOid())

_nameAttribute = asset_type.getAttributeDefinition("Name")
_numberAttribute = asset_type.getAttributeDefinition("Number")
_createDateAttribute = asset_type.getAttributeDefinition("CreateDate")
_createdByAttribute = asset_type.getAttributeDefinition("CreatedBy")

_query.getSelection().add(_nameAttribute)
_query.getSelection().add(_numberAttribute)
_query.getSelection().add(_createDateAttribute)
_query.getSelection().add(_createdByAttribute)

_result = services.retrieve(_query)
_asset = _result.getAssets()[0]

_asset_name = _asset.getAttribute(_nameAttribute).value
_asset_number = _asset.getAttribute(_numberAttribute).value
_asset_create_date_str = str(_asset.getAttribute(_createDateAttribute).value)
_asset_create_date = convert_to_datetime(_asset_create_date_str)
_asset_created_by = str(_asset.getAttribute(_createdByAttribute).value)

# Getting member details
_memberData = _asset_created_by.split(":")
_memberId = _memberData[1]
_memberDetails = v1Client.getMember(id=_memberId)
_memberName = _memberDetails['Attributes']['Name']['value']

# Printing output properties
token = new_asset_oid.getToken()
assetNumber = _asset_number
data["Token"] = token
data["AssetNumber"] = assetNumber

# Getting asset url
versionOneServerUrl = versionOneServer['url']
tokenData = token.split(":")
asset_type = tokenData[0]
asset_oid = tokenData[1]
asset_url = versionOneServerUrl + "/" + asset_type + ".mvc/Summary?oidToken=" + asset_type + "%3A" + asset_oid

# Printing asset details
print("Asset Number=%s") % _asset_number
print("Asset Name=%s") % _asset_name
print("Asset Type=%s") % asset_type
print("Asset OID=%s") % new_asset_oid
print("Created Date=%s") % _asset_create_date
print("Created By=%s") % _memberName
print("Asset URL=%s") % asset_url