/*
 * Decompiled with CFR 0.152.
 */
package com.versionone;

import com.versionone.utils.HashCode;

public class Duration {
    private int _amount;
    private Unit _units;

    public Duration() {
        this(0, Unit.Days);
    }

    public Duration(int amount, Unit units) {
        this._units = units;
        this.setAmount(amount);
    }

    public Duration(String value) {
        this(0, Unit.Days);
        if (value == null || value.length() == 0) {
            return;
        }
        try {
            String[] parts = value.split(" ");
            this.setAmount(Integer.parseInt(parts[0]));
            if (this._amount != 0) {
                this._units = Unit.valueOf(parts[1]);
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Not a valid Duration: " + value, e);
        }
    }

    public int getAmount() {
        return this._amount;
    }

    public Unit getUnits() {
        return this._units;
    }

    public int getDays() {
        switch (this._units) {
            case Days: {
                return this._amount;
            }
            case Weeks: {
                return this._amount * 7;
            }
            case Months: {
                if (this._amount <= 1) {
                    return this._amount * 30;
                }
                if (this._amount < 12) {
                    return this._amount * 61 / 2;
                }
                return this._amount * 365 / 12;
            }
        }
        throw new UnsupportedOperationException();
    }

    public static boolean compare(Duration a, Duration b) {
        if (null == a || null == b) {
            return null == a && null == b;
        }
        return a.equals(b);
    }

    public static Duration parse(String value) {
        return new Duration(value);
    }

    public String toString() {
        return this._amount + " " + this._units.toString();
    }

    public boolean equals(Object obj) {
        boolean rc = false;
        if (obj != null && obj instanceof Duration) {
            Duration other = (Duration)obj;
            rc = this._amount == other.getAmount() && this._units == other.getUnits();
        }
        return rc;
    }

    public int hashCode() {
        return HashCode.Hash((Object)this._amount, (Object)this._units);
    }

    private void setAmount(int amount) {
        if (amount < 0) {
            throw new IllegalArgumentException("Amount must be non-negative");
        }
        this._amount = amount;
        if (amount == 0) {
            this._units = Unit.Days;
        }
    }

    public static enum Unit {
        Days,
        Weeks,
        Months;

    }
}

