from xlrxldeploy import *
from xldeploy.domain.QueryBuilder import QueryBuilder


def get_all_versions(task):
    application_id = get_task_property(task, "applicationId")

    if get_task_property(task, "throwOnFail") and not check_ci_exist(task, application_id):
        raise Exception(application_id + " does not exist")

    params = QueryBuilder().parent(application_id).result_per_page(-1).build()
    client = get_api_client(get_task_property(task, "server"), task)
    try:
        versions = client.repository.query(params)
        return list(map(lambda version: version["ref"], versions))
    except:
        return []


def get_latest_version(task):
    versions = get_all_versions(task)

    latest_package = ''
    if len(versions) > 0:
        latest_package = versions[-1]

    return latest_package


def get_last_version_deployed(task):
    client = get_api_client(get_task_property(task, "server"), task)
    ci = client.repository.read("{}/{}".format(get_task_property(task, "environmentId"),
                                               get_task_property(task, "applicationName")))
    return ci.version


def get_task_property(task, property):
    return task.getPythonScript().getProperty(property)
