/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.depend.DependencyManager;
import org.apache.derby.iapi.sql.dictionary.ConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.ConstraintDescriptorList;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.ForeignKeyConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.ReferencedKeyConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.impl.sql.execute.ConstraintConstantAction;
import org.apache.derby.impl.sql.execute.IndexConstantAction;
import org.apache.derby.shared.common.error.StandardException;

public class DropConstraintConstantAction
extends ConstraintConstantAction {
    private boolean cascade;
    private String constraintSchemaName;
    private int verifyType;

    DropConstraintConstantAction(String string, String string2, String string3, UUID uUID, String string4, IndexConstantAction indexConstantAction, int n, int n2) {
        super(string, 5, string3, uUID, string4, indexConstantAction);
        this.cascade = n == 0;
        this.constraintSchemaName = string2;
        this.verifyType = n2;
    }

    public String toString() {
        if (this.constraintName == null) {
            return "DROP PRIMARY KEY";
        }
        String string = this.constraintSchemaName == null ? this.schemaName : this.constraintSchemaName;
        return "DROP CONSTRAINT " + string + "." + this.constraintName;
    }

    @Override
    public void executeConstantAction(Activation activation) throws StandardException {
        boolean bl;
        ConstraintDescriptor constraintDescriptor = null;
        Object var4_3 = null;
        LanguageConnectionContext languageConnectionContext = activation.getLanguageConnectionContext();
        DataDictionary dataDictionary = languageConnectionContext.getDataDictionary();
        DependencyManager dependencyManager = dataDictionary.getDependencyManager();
        TransactionController transactionController = languageConnectionContext.getTransactionExecute();
        dataDictionary.startWriting(languageConnectionContext);
        TableDescriptor tableDescriptor = dataDictionary.getTableDescriptor(this.tableId);
        if (tableDescriptor == null) {
            throw StandardException.newException((String)"X0X05.S", (Object[])new Object[]{this.tableName});
        }
        SchemaDescriptor schemaDescriptor = tableDescriptor.getSchemaDescriptor();
        SchemaDescriptor schemaDescriptor2 = this.constraintSchemaName == null ? schemaDescriptor : dataDictionary.getSchemaDescriptor(this.constraintSchemaName, transactionController, true);
        constraintDescriptor = this.constraintName == null ? dataDictionary.getConstraintDescriptors(tableDescriptor).getPrimaryKey() : dataDictionary.getConstraintDescriptorByName(tableDescriptor, schemaDescriptor2, this.constraintName, true);
        if (constraintDescriptor == null) {
            String string = this.constraintName == null ? "PRIMARY KEY" : schemaDescriptor2.getSchemaName() + "." + this.constraintName;
            throw StandardException.newException((String)"42X86", (Object[])new Object[]{string, tableDescriptor.getQualifiedName()});
        }
        switch (this.verifyType) {
            case 3: {
                if (constraintDescriptor.getConstraintType() == this.verifyType) break;
                throw StandardException.newException((String)"42Z9E", (Object[])new Object[]{this.constraintName, "UNIQUE"});
            }
            case 4: {
                if (constraintDescriptor.getConstraintType() == this.verifyType) break;
                throw StandardException.newException((String)"42Z9E", (Object[])new Object[]{this.constraintName, "CHECK"});
            }
            case 6: {
                if (constraintDescriptor.getConstraintType() == this.verifyType) break;
                throw StandardException.newException((String)"42Z9E", (Object[])new Object[]{this.constraintName, "FOREIGN KEY"});
            }
        }
        boolean bl2 = bl = this.cascade && constraintDescriptor instanceof ReferencedKeyConstraintDescriptor;
        if (!bl) {
            dependencyManager.invalidateFor(constraintDescriptor, 19, languageConnectionContext);
        }
        this.dropConstraint(constraintDescriptor, activation, languageConnectionContext, !bl);
        if (bl) {
            ReferencedKeyConstraintDescriptor referencedKeyConstraintDescriptor = (ReferencedKeyConstraintDescriptor)constraintDescriptor;
            ConstraintDescriptorList constraintDescriptorList = referencedKeyConstraintDescriptor.getForeignKeyConstraints(3);
            int n = constraintDescriptorList.size();
            for (int i = 0; i < n; ++i) {
                ForeignKeyConstraintDescriptor foreignKeyConstraintDescriptor = (ForeignKeyConstraintDescriptor)constraintDescriptorList.elementAt(i);
                dependencyManager.invalidateFor(foreignKeyConstraintDescriptor, 19, languageConnectionContext);
                this.dropConstraint(foreignKeyConstraintDescriptor, activation, languageConnectionContext, true);
            }
            dependencyManager.invalidateFor(constraintDescriptor, 19, languageConnectionContext);
            dependencyManager.clearDependencies(languageConnectionContext, constraintDescriptor);
        }
    }
}

