#
# Copyright (c) 2023. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries, and licensors.
#

import sys
import java

def convert_to_datetime(from_date):
    sdf = java.text.SimpleDateFormat("EEE MMM dd kk:mm:ss zzz yyyy")
    return sdf.parse(from_date)

def add_code_compliance_plan_record(task_reporting_api, task, opaServer,
                         policy_name=None,status=None,type=None,complianceData=None,analysisDate=None):
    try:
        record = task_reporting_api.newCodeComplianceRecord()
        record.targetId = task.id
        record.serverUrl = opaServer['url'] if opaServer else "Not available"
        record.serverUser = "Not available"
        record.project = policy_name
        record.project_url = "Not available"
        record.analysisDate = analysisDate
        record.outcome = status
        record.complianceData = complianceData
        task_reporting_api.addRecord(record, True)
    except:
        exctype, value = sys.exc_info()[:2]
        print("{} occurred while creating `udm.CodeComplianceRecord` - {}".format(exctype, value))