#
# Copyright (c) 2020. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries, and licensors.
#

import logging
import re

from vault import VaultClient

logger = logging.getLogger("Vault")
print("VAULT V1: Executing %s" % task.getTaskType())
vault_client = VaultClient(url=vaultServer['url'], token=vaultServer['token'], username=vaultServer['username'],
                           password=vaultServer['password'], namespace=vaultServer['namespace'],
                           authenticationMethod=vaultServer['authenticationMethod'], role_id=vaultServer['role_id'], secret_id=vaultServer['secret_id'], logger=logger)
# Use the name of the type in multiple places.
mytype = str(task.getTaskType())
print("=== VAULT SECRET V1 : {} ===".format(mytype))

def getMaskedValue(value):
    return re.sub(r'.*', '*******', value)

if vaultServer['namespace'] is not None and len(vaultServer['namespace']) > 0:
    print("Namespace Provided so Vault Initialization Check is Skipped")
elif vault_client.client.sys.is_initialized():
    print("Vault Initialized:{}".format(vaultServer['url']))
else:
    vault_client.exit(vault_client.VAULT_NOT_INITIALIZED,
                      "Your Vault Server at {} is not initialized".format(vaultServer['url']), authenticationType=str(vaultServer['authenticationMethod']))

if vault_client.client.sys.is_sealed():
    vault_client.exit(vault_client.VAULT_SERVER_SEALED, "Vault Server {} is Sealed".format(vaultServer['url']), authenticationType=str(vaultServer['authenticationMethod']))

if vaultServer['authenticationMethod'] == "PAT":
    if vaultServer['token'] is None:
        vault_client.exit(vault_client.VAULT_NO_TOKEN, "You must use a token in Vault for Token Authentication", authenticationType=str(vaultServer['authenticationMethod']))
if vaultServer['authenticationMethod'] == "Basic" or vaultServer['authenticationMethod'] == "LDAP":
    if vaultServer['username'] is None:
        vault_client.exit(vault_client.VAULT_NO_TOKEN,
                          "You must use username/password in Vault for Basic/LDAP Authentication", authenticationType=str(vaultServer['authenticationMethod']))
if vaultServer['authenticationMethod'] == "Approle":
    if vaultServer['role_id'] is None:
        vault_client.exit(vault_client.VAULT_NO_TOKEN,
                          "You must use RoleId/SecretId in Vault for Approle Authentication", authenticationType=str(vaultServer['authenticationMethod']))

if vault_client.client.is_authenticated():
    print("Vault authenticated against {}".format(vaultServer['url']))
else:
    vault_client.exit(vault_client.VAULT_NOT_AUTHENTICATED, "Vault Server is not authenticated", authenticationType=str(vaultServer['authenticationMethod']))

if mytype == 'vault.SecretsV1-ReadSecret':
    key_path = path + '/' + key
    print("Reading from {}".format(key_path))
    read_response = vault_client.client.secrets.kv.v1.read_secret(mount_point=mount_point, path=path)
    value = read_response['data'][key]
    print(">> Read Secret Request complete for {}/{}/{} - {}".format(mount_point, path, key, getMaskedValue(value)))
    if key.encode('ascii', 'ignore') not in read_response['data']:
        print("Key {} not found in path  ", key_path)
    print("===============================================================")

elif mytype == 'vault.SecretsV1-ReadDynamicSecret':
    print("ReadDynamic Not Implemented")

elif mytype == 'vault.SecretsV1-CreateSecret':
    masked_secret = {key: getMaskedValue(value)}
    print(">> Writing {} to {}".format(masked_secret, path))
    new_secret = {key: value}
    create_response = vault_client.client.secrets.kv.v1.create_or_update_secret(mount_point=mount_point, path=path,
                                                                                secret=new_secret)
    print(">> Write Request complete for {} : {}".format(path, create_response))
    print("===============================================================")

elif mytype == 'vault.SecretsV1-DeleteSecret':
    delete_response = vault_client.client.secrets.kv.v1.delete_secret(mount_point=mount_point, path=path)
    print(">> Delete Request complete for {}/{} - {}".format(mount_point, path, delete_response))
    print("===============================================================")

elif mytype == 'vault.SecretsV1-EnableEngine':
    ErrorString = ""
    if backend_type == None or backend_type == "":
        ErrorString += "backend_type"
    if mount_point == None or mount_point == "":
        ErrorString += " mount_point"
    if ErrorString != "" or len(ErrorString) > 0:
        exit("VAULT Error - Please check these Fields :" + ErrorString)
    else:
        vault_client.client.sys.enable_secrets_engine(backend_type, mount_point, engine_description, None, None, None,
                                                      auth_local, False)
    print("New " + backend_type + " Engine Enabled - V1")

elif mytype == "vault.SecretsV1-ListSecrets":
    response = vault_client.client.secrets.kv.v1.list_secrets(path='', mount_point=mount_point)
    print('The following secrets are available under {} prefix: {keys}'.format(mount_point, keys=', '.join(
        response['data']['keys'])))

else:
    print("Not Implemented {}".format(mytype))

if vaultServer['authenticationMethod'] == "Basic" or vaultServer['authenticationMethod'] == "LDAP" or vaultServer['authenticationMethod'] == "Approle":
    vault_client.revokeUserPassToken()
