#
# Copyright (c) 2020. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries, and licensors.
#

import logging

from vault import VaultClient
from com.xebialabs.xlrelease.plugin.vault import VaultServer

logger = logging.getLogger("Vault")
print("VAULT V2: Executing %s" % task.getTaskType())
vault_client = VaultClient(url=vaultServer['url'], token=vaultServer['token'], username=vaultServer['username'],
                           password=vaultServer['password'], namespace=vaultServer['namespace'],
                           authenticationMethod=vaultServer['authenticationMethod'], role_id=vaultServer['role_id'], secret_id=vaultServer['secret_id'], logger=logger)

# Use the name of the type in multiple places.
mytype = str(task.getTaskType())
print("=== VAULT SECRET V2 : {} ===".format(mytype))


def getMaskedValue(value):
    return re.sub(r'.*', '*******', value)


if vaultServer['namespace'] is not None and len(vaultServer['namespace']) > 0:
    print("Namespace Provided so Vault Initialization Check is Skipped")
elif vault_client.client.sys.is_initialized():
    print("Vault Initialized:{}".format(vaultServer['url']))
else:
    vault_client.exit(vault_client.VAULT_NOT_INITIALIZED,
                      "Your Vault Server at {} is not initialized".format(vaultServer['url']), authenticationType=str(vaultServer['authenticationMethod']))

if vault_client.client.sys.is_sealed():
    vault_client.exit(vault_client.VAULT_SERVER_SEALED, "Vault Server {} is Sealed".format(vaultServer['url']), authenticationType=str(vaultServer['authenticationMethod']))

if vaultServer['authenticationMethod'] == "PAT":
    if vaultServer['token'] is None:
        vault_client.exit(vault_client.VAULT_NO_TOKEN, "You must use a token in Vault for Token Authentication", authenticationType=str(vaultServer['authenticationMethod']))
if vaultServer['authenticationMethod'] == "Basic" or vaultServer['authenticationMethod'] == "LDAP":
    if vaultServer['username'] is None:
        vault_client.exit(vault_client.VAULT_NO_TOKEN,
                          "You must use username/password in Vault for Basic/LDAP Authentication", authenticationType=str(vaultServer['authenticationMethod']))
if vaultServer['authenticationMethod'] == "Approle":
    if vaultServer['role_id'] is None:
        vault_client.exit(vault_client.VAULT_NO_TOKEN,
                          "You must use RoleId/SecretId in Vault for Approle Authentication", authenticationType=str(vaultServer['authenticationMethod']))

if not vault_client.client.is_authenticated():
    vault_client.exit(vault_client.VAULT_NOT_AUTHENTICATED, "Vault Server is not authenticated", authenticationType=str(vaultServer['authenticationMethod']))

# vault.SecretsV2.Read
if mytype == 'vault.SecretsV2-Configure':
    response = vault_client.client.secrets.kv.v2.configure(max_versions=max_versions, mount_point=mount_point,
                                                           cas_required=cas_required)
    print("SecretsV2-Configuration response is {}".format(response))

elif mytype == 'vault.SecretsV2-EnableEngine':
    ErrorString = ""
    if backend_type == None or backend_type == "":
        ErrorString += "backend_type"
    if mount_point == None or mount_point == "":
        ErrorString += " mount_point"
    if ErrorString != "" or len(ErrorString) > 0:
        exit("VAULT Error - Please check these Fields :" + ErrorString)
    else:
        options = {'version': '2'}
        vault_client.client.sys.enable_secrets_engine(backend_type, mount_point, engine_description, None, None,
                                                      options, auth_local, False)
    print("New " + mount_point + " Engine Enabled - V2")

elif mytype == 'vault.SecretsV2-ReadSecret':
    key_path = path + '/' + key
    print("Reading from {}".format(key_path))
    read_response = vault_client.client.secrets.kv.v2.read_secret(mount_point=mount_point, path=path)
    value = read_response['data']['data'][key]
    print(">> Read Secret Request complete for {}/{}/{} - {}".format(mount_point, path, key, getMaskedValue(value)))
    if value is None:
        print("Key {} not found in path  ", key_path)

elif mytype == 'vault.SecretsV2-ReadConfiguration':
    kv_configuration = vault_client.client.secrets.kv.v2.read_configuration(mount_point=mount_point)
    print('Config under path "kv": max_versions set to "{max_ver}"'.format(
        max_ver=kv_configuration['data']['max_versions'], ))
    print('Config under path "kv": check-and-set require flag set to {cas}'.format(
        cas=kv_configuration['data']['cas_required'], ))

elif mytype == "vault.SecretsV2-ReadSecretVersions":
    secret_version_response = vault_client.client.secrets.kv.v2.read_secret_version(path=path, version=version,
                                                                                    mount_point=mount_point)
    print('Version {} of secret under path {} contains the following keys: {data}'.format(
        version, path, data=(secret_version_response['data']['data'].keys()), ))
    print('Version {} of secret under path {} created at: {date}'.format(
        version, path, date=secret_version_response['data']['metadata']['created_time'], ))

elif mytype == "vault.SecretsV2-CreateSecret":
    print('CreateSecret has these values for path, key, cas = {},{},{}'.format(path, key, cas))
    newsecret = {key: value}
    if cas:
        response = vault_client.client.secrets.kv.v2.create_or_update_secret(path=path, secret=newsecret, cas=cas,
                                                                             mount_point=mount_point)
        # Raises hvac.exceptions.InvalidRequest
    else:
        response = vault_client.client.secrets.kv.v2.create_or_update_secret(path=path, secret=newsecret,
                                                                             mount_point=mount_point)
    version = response['data']['version']
    print("VAULT: Response = %s" % response)

elif mytype == "vault.SecretsV2-PatchExistingSecret":
    response = vault_client.client.secrets.kv.v2.patch(path=path, secret=dict(key=value), mount_point=mount_point)
    print("Response is {}".format(response))

elif mytype == "vault.SecretsV2-DeleteVersion":
    if latest:  # Delete the latest version
        response = vault_client.client.secrets.kv.v2.delete_latest_version_of_secret(path=path, mount_point=mount_point)
    else:  # Need to delete a specific version
        response = vault_client.client.secrets.kv.v2.delete_secret_versions(path=path, mount_point=mount_point,
                                                                            versions=version.split(","))

elif mytype == "vault.SecretsV2-UndeleteVersion":
    response = vault_client.client.secrets.kv.v2.undelete_secret_versions(path=path, mount_point=mount_point,
                                                                          versions=version.split(","))
    print("Response is {}".format(response))

elif mytype == "vault.SecretsV2-DestroyVersion":
    response = vault_client.client.secrets.kv.v2.destroy_secret_versions(path=path, mount_point=mount_point,
                                                                         versions=version.split(","))
    print("Response is {}".format(response))

elif mytype == "vault.SecretsV2-ListSecrets":
    response = vault_client.client.secrets.kv.v2.list_secrets(path='', mount_point=mount_point)
    print('Response is ', response)
    print('The following secrets are available under {} prefix: {keys}'.format(mount_point,
                                                                               keys=','.join(response['data']['keys'])))

elif mytype == "vault.SecretsV2-ReadSecretMetadata":
    hvac_path_metadata = vault_client.client.secrets.kv.v2.read_secret_metadata(path=path, mount_point=mount_point)
    print('Metadata under path {} is {}'.format(path, hvac_path_metadata))

elif mytype == "vault.SecretsV2-UpdateMetaData":
    response = vault_client.client.secrets.kv.v2.update_metadata(path=path, mount_point=mount_point,
                                                                 max_versions=max_versions, cas_required=cas)
    print("Response is {}".format(response))

elif mytype == "vault.SecretsV2-DeleteMetaDataAndAllVersions":
    response = vault_client.client.secrets.kv.v2.delete_metadata_and_all_versions(path=path, mount_point=mount_point)
    print("Response is {}".format(response))

else:
    print("Not Implemented {}".format(mytype))

if vaultServer['authenticationMethod'] == "Basic" or vaultServer['authenticationMethod'] == "LDAP" or vaultServer['authenticationMethod'] == "Approle":
    vault_client.revokeUserPassToken()
