/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.domain;

import com.xebialabs.deployit.booter.local.utils.Strings;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import org.apache.commons.lang3.text.WordUtils;

public class TaskDefinition {
    public static final String XLRELEASE_GROUP_REPLACEMENT = "Core";
    public static final String XLRELEASE_GROUP = "xlrelease";
    public static final String XEBIALABS_GROUP = "xebialabs";
    protected String typeName;
    protected String displayGroup;
    protected String displayName;
    protected boolean allowed;

    public TaskDefinition(Type type, boolean allowed) {
        this.typeName = type.toString();
        this.displayGroup = TaskDefinition.getDisplayGroup(type);
        this.displayName = TaskDefinition.getDisplayName(type);
        this.allowed = allowed;
    }

    public static String getDisplayGroup(Type type) {
        String prefix = TaskDefinition.getPrefix(type);
        return TaskDefinition.isCore(prefix) ? XLRELEASE_GROUP_REPLACEMENT : prefix;
    }

    public static String getDisplayName(Type type) {
        String groupPrefix;
        String label = type.getDescriptor().getLabel();
        if (label.startsWith(groupPrefix = TaskDefinition.getPrefix(type) + ": ")) {
            label = label.replace(groupPrefix, "");
        }
        return label;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public String getDisplayGroup() {
        return this.displayGroup;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public boolean isAllowed() {
        return this.allowed;
    }

    protected static String getPrefix(Type type) {
        if (type.getDescriptor().getLabel().contains(":")) {
            return type.getDescriptor().getLabel().split(":")[0];
        }
        if (TaskDefinition.isCore(type.getPrefix())) {
            return type.getPrefix();
        }
        return WordUtils.capitalize((String)Strings.deCamelize((String)type.getPrefix()).toLowerCase());
    }

    protected static boolean isCore(String prefix) {
        return prefix.equalsIgnoreCase(XLRELEASE_GROUP) || prefix.equalsIgnoreCase(XEBIALABS_GROUP);
    }
}

