#
# Copyright (c) 2019. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of XebiaLabs, Inc. and its affiliates, subsidiaries and licensors.
#

from java.util.concurrent import Callable

from fortifyOnDemand import FortifyOnDemandService

NOT_SET_VALUE = '(Not Set)'
LIMIT = 50


class GetApplicationReleaseTask(Callable):
    def __init__(self, fortify_on_demand_server, project_name, offset, limit=LIMIT):
        self._fortify_on_demand_server = fortify_on_demand_server
        self._project_name = project_name
        self._offset = offset
        self._limit = limit
        self.result = None
        self.exception = None

    def call(self):
        try:
            response = FortifyOnDemandService.get_releases_by_application_name(self._fortify_on_demand_server, application_name=self._project_name,
                                                                               offset=self._offset, limit=self._limit)
            self.result = response.get('items')
        except Exception as ex:
            self.exception = ex
        return self


class GetReleaseVulnerabilityFiltersTask(Callable):
    def __init__(self, fortify_on_demand_server, fortify_on_demand_standards, release):
        self._release = release
        self._fortify_on_demand_standards = fortify_on_demand_standards
        self._fortify_on_demand_server = fortify_on_demand_server
        self.result = None
        self.exception = None

    def call(self):
        try:
            response = FortifyOnDemandService.get_release_vulnerability_filters(self._fortify_on_demand_server, self._release['releaseId'])
            self.result = self._release

            self.result['vulnerabilities'] = {}
            for vulnerability in response.get('items'):
                if vulnerability['fieldName'] in self._fortify_on_demand_standards:
                    self.result['vulnerabilities'][vulnerability['fieldName']] = list(
                        filter(lambda v: v['value'] != NOT_SET_VALUE, vulnerability['fieldFilterValues']))
        except Exception as ex:
            self.exception = ex
        return self
