/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.support.tools;

import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.xlrelease.actors.ReleaseActorService;
import com.xebialabs.xlrelease.actors.utils.ReleaseActorLifecycleUtils;
import com.xebialabs.xlrelease.db.ArchivedReleases;
import com.xebialabs.xlrelease.domain.status.TaskStatus;
import com.xebialabs.xlrelease.exception.LogFriendlyNotFoundException;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.ReleaseRepository;
import com.xebialabs.xlrelease.service.ArchivingService;
import com.xebialabs.xlrelease.support.tools.SupportUtilitiesActorExtensionHandlerFactory;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.concurrent.duration.FiniteDuration$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@Service
@ScalaSignature(bytes="\u0006\u0005\u00055b\u0001\u0002\b\u0010\u0001iA\u0001\"\u000b\u0001\u0003\u0006\u0004%\tA\u000b\u0005\tc\u0001\u0011\t\u0011)A\u0005W!A!\u0007\u0001BC\u0002\u0013\u00051\u0007\u0003\u0005;\u0001\t\u0005\t\u0015!\u00035\u0011!Y\u0004A!b\u0001\n\u0003a\u0004\u0002C\"\u0001\u0005\u0003\u0005\u000b\u0011B\u001f\t\u0011\u0011\u0003!Q1A\u0005\u0002\u0015C\u0001B\u0014\u0001\u0003\u0002\u0003\u0006IA\u0012\u0005\t\u001f\u0002\u0011\t\u0011)A\u0005!\")A\u000b\u0001C\u0001+\")A\u000e\u0001C\u0001[\"9\u0011\u0011\u0003\u0001\u0005\u0002\u0005M\u0001bBA\r\u0001\u0011\u0005\u00111\u0004\u0002\u0011'V\u0004\bo\u001c:u+RLG.\u001b;jKNT!\u0001E\t\u0002\u000bQ|w\u000e\\:\u000b\u0005I\u0019\u0012aB:vaB|'\u000f\u001e\u0006\u0003)U\t\u0011\u0002\u001f7sK2,\u0017m]3\u000b\u0005Y9\u0012!\u0003=fE&\fG.\u00192t\u0015\u0005A\u0012aA2p[\u000e\u00011c\u0001\u0001\u001cCA\u0011AdH\u0007\u0002;)\ta$A\u0003tG\u0006d\u0017-\u0003\u0002!;\t1\u0011I\\=SK\u001a\u0004\"AI\u0014\u000e\u0003\rR!\u0001J\u0013\u0002\u000bMdg\r\u000e6\u000b\u0003\u0019\n\u0001b\u001a:jujdW\rZ\u0005\u0003Q\r\u0012q\u0001T8hO&tw-\u0001\tbe\u000eD\u0017N^5oON+'O^5dKV\t1\u0006\u0005\u0002-_5\tQF\u0003\u0002/'\u000591/\u001a:wS\u000e,\u0017B\u0001\u0019.\u0005A\t%o\u00195jm&twmU3sm&\u001cW-A\tbe\u000eD\u0017N^5oON+'O^5dK\u0002\n\u0011C]3mK\u0006\u001cXMU3q_NLGo\u001c:z+\u0005!\u0004CA\u001b9\u001b\u00051$BA\u001c\u0014\u0003)\u0011X\r]8tSR|'/_\u0005\u0003sY\u0012\u0011CU3mK\u0006\u001cXMU3q_NLGo\u001c:z\u0003I\u0011X\r\\3bg\u0016\u0014V\r]8tSR|'/\u001f\u0011\u0002!\u0005\u00148\r[5wK\u0012\u0014V\r\\3bg\u0016\u001cX#A\u001f\u0011\u0005y\nU\"A \u000b\u0005\u0001\u001b\u0012A\u00013c\u0013\t\u0011uH\u0001\tBe\u000eD\u0017N^3e%\u0016dW-Y:fg\u0006\t\u0012M]2iSZ,GMU3mK\u0006\u001cXm\u001d\u0011\u00025I,G.Z1tK\u0006\u001bGo\u001c:MS\u001a,7-_2mKV#\u0018\u000e\\:\u0016\u0003\u0019\u0003\"a\u0012'\u000e\u0003!S!!\u0013&\u0002\u000bU$\u0018\u000e\\:\u000b\u0005-\u001b\u0012AB1di>\u00148/\u0003\u0002N\u0011\nQ\"+\u001a7fCN,\u0017i\u0019;pe2Kg-Z2zG2,W\u000b^5mg\u0006Y\"/\u001a7fCN,\u0017i\u0019;pe2Kg-Z2zG2,W\u000b^5mg\u0002\n1C]3mK\u0006\u001cX-Q2u_J\u001cVM\u001d<jG\u0016\u0004\"!\u0015*\u000e\u0003)K!a\u0015&\u0003'I+G.Z1tK\u0006\u001bGo\u001c:TKJ4\u0018nY3\u0002\rqJg.\u001b;?)\u00191\u0006,\u0017.\\9B\u0011q\u000bA\u0007\u0002\u001f!)\u0011F\u0003a\u0001W!)!G\u0003a\u0001i!)1H\u0003a\u0001{!)AI\u0003a\u0001\r\")qJ\u0003a\u0001!\"\u0012!B\u0018\t\u0003?*l\u0011\u0001\u0019\u0006\u0003C\n\f!\"\u00198o_R\fG/[8o\u0015\t\u0019G-A\u0004gC\u000e$xN]=\u000b\u0005\u00154\u0017!\u00022fC:\u001c(BA4i\u0003=\u0019\bO]5oO\u001a\u0014\u0018-\\3x_J\\'\"A5\u0002\u0007=\u0014x-\u0003\u0002lA\nI\u0011)\u001e;po&\u0014X\rZ\u0001\u0011kB$\u0017\r^3UCN\\7\u000b^1ukN$2A\\9\u007f!\tar.\u0003\u0002q;\t!QK\\5u\u0011\u0015\u00118\u00021\u0001t\u0003\u0019!\u0018m]6JIB\u0011Ao\u001f\b\u0003kf\u0004\"A^\u000f\u000e\u0003]T!\u0001_\r\u0002\rq\u0012xn\u001c;?\u0013\tQX$\u0001\u0004Qe\u0016$WMZ\u0005\u0003yv\u0014aa\u0015;sS:<'B\u0001>\u001e\u0011\u0019y8\u00021\u0001\u0002\u0002\u0005Ia.Z<Ti\u0006$Xo\u001d\t\u0005\u0003\u0007\ti!\u0004\u0002\u0002\u0006)!\u0011qAA\u0005\u0003\u0019\u0019H/\u0019;vg*\u0019\u00111B\n\u0002\r\u0011|W.Y5o\u0013\u0011\ty!!\u0002\u0003\u0015Q\u000b7o[*uCR,8/A\thKR\u0014V\r\\3bg\u0016\u001cuN\u001c;f]R$2a]A\u000b\u0011\u0019\t9\u0002\u0004a\u0001g\u0006I!/\u001a7fCN,\u0017\nZ\u0001\u000eI\u0016dW\r^3SK2,\u0017m]3\u0015\u00079\fi\u0002\u0003\u0004\u0002\u00185\u0001\ra\u001d\u0015\u0004\u0001\u0005\u0005\u0002\u0003BA\u0012\u0003Si!!!\n\u000b\u0007\u0005\u001db-\u0001\u0006ti\u0016\u0014Xm\u001c;za\u0016LA!a\u000b\u0002&\t91+\u001a:wS\u000e,\u0007")
public class SupportUtilities
implements Logging {
    private final ArchivingService archivingService;
    private final ReleaseRepository releaseRepository;
    private final ArchivedReleases archivedReleases;
    private final ReleaseActorLifecycleUtils releaseActorLifecycleUtils;
    private final ReleaseActorService releaseActorService;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        SupportUtilities supportUtilities = this;
        synchronized (supportUtilities) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public ArchivingService archivingService() {
        return this.archivingService;
    }

    public ReleaseRepository releaseRepository() {
        return this.releaseRepository;
    }

    public ArchivedReleases archivedReleases() {
        return this.archivedReleases;
    }

    public ReleaseActorLifecycleUtils releaseActorLifecycleUtils() {
        return this.releaseActorLifecycleUtils;
    }

    public void updateTaskStatus(String taskId, TaskStatus newStatus) {
        String releaseId = Ids.releaseIdFrom((String)taskId);
        Checks.checkArgument((boolean)this.releaseRepository().exists(releaseId), (String)new StringBuilder(20).append("Release [").append(releaseId).append("] not found").toString(), (Object[])new Object[0]);
        this.releaseActorService.executeCommand(taskId, new SupportUtilitiesActorExtensionHandlerFactory.ForceTaskStatus(taskId, newStatus));
    }

    public String getReleaseContent(String releaseId) {
        if (this.releaseRepository().exists(releaseId)) {
            return this.releaseRepository().getReleaseJson(releaseId);
        }
        return (String)this.archivedReleases().getRelease(releaseId, this.archivedReleases().getRelease$default$2()).getOrElse((Function0 & Serializable)() -> {
            throw new LogFriendlyNotFoundException(new StringBuilder(20).append("Release [").append(releaseId).append("] not found").toString(), new Object[0]);
        });
    }

    public void deleteRelease(String releaseId) {
        String string;
        Checks.checkArgument((this.releaseRepository().exists(releaseId) || this.archivedReleases().exists(releaseId) ? 1 : 0) != 0, (String)new StringBuilder(20).append("Release [").append(releaseId).append("] not found").toString(), (Object[])new Object[0]);
        try {
            string = this.releaseActorLifecycleUtils().terminateReleaseActorAndAwait(releaseId, FiniteDuration$.MODULE$.apply(5L, TimeUnit.SECONDS));
        }
        catch (Exception e) {
            this.logger().error((Function0 & Serializable)() -> new StringBuilder(49).append("Could not terminate release actor ").append(releaseId).append(" within timeout").toString(), (Function0 & Serializable)() -> e);
            string = BoxedUnit.UNIT;
        }
        this.archivedReleases().deleteReleaseFromArchive(releaseId);
        if (this.releaseRepository().exists(releaseId)) {
            try {
                this.archivingService().archiveAllIncomingDependencies(releaseId);
            }
            catch (Exception e) {
                this.logger().error((Function0 & Serializable)() -> new StringBuilder(43).append("Could not archive incoming dependencies to ").append(releaseId).toString(), (Function0 & Serializable)() -> e);
            }
            this.releaseRepository().delete(releaseId, false);
            return;
        }
    }

    @Autowired
    public SupportUtilities(ArchivingService archivingService, ReleaseRepository releaseRepository, ArchivedReleases archivedReleases, ReleaseActorLifecycleUtils releaseActorLifecycleUtils, ReleaseActorService releaseActorService) {
        this.archivingService = archivingService;
        this.releaseRepository = releaseRepository;
        this.archivedReleases = archivedReleases;
        this.releaseActorLifecycleUtils = releaseActorLifecycleUtils;
        this.releaseActorService = releaseActorService;
        Logging.$init$((Logging)this);
    }
}

