/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.export;

import com.xebialabs.deployit.checks.Checks;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plumbing.export.ImportTemplateConfigurationItemReaderWriter;
import com.xebialabs.deployit.plumbing.serialization.ResolutionContext;
import com.xebialabs.deployit.plumbing.serialization.ResolutionContext$;
import com.xebialabs.overthere.local.LocalFile;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.export.BaseTemplateImporter;
import com.xebialabs.xlrelease.export.JsonTemplateContent;
import com.xebialabs.xlrelease.export.TemplateImportContext;
import com.xebialabs.xlrelease.export.TemplateImportProcessor;
import com.xebialabs.xlrelease.export.TemplateImportUpgrader;
import com.xebialabs.xlrelease.service.ReleaseService;
import com.xebialabs.xlrelease.service.TaskAccessService;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import javax.ws.rs.core.MediaType;
import org.apache.commons.io.IOUtils;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONObject;
import org.springframework.stereotype.Component;
import scala.Function0;
import scala.Option$;
import scala.reflect.ScalaSignature;

@Component
@ScalaSignature(bytes="\u0006\u0005\u0005=d\u0001\u0002\u0007\u000e\u0001YA\u0001B\b\u0001\u0003\u0002\u0003\u0006Ia\b\u0005\tE\u0001\u0011\t\u0011)A\u0005G!A\u0011\u0006\u0001B\u0001B\u0003%!\u0006\u0003\u0005.\u0001\t\u0005\t\u0015!\u0003/\u0011!9\u0004A!A!\u0002\u0013A\u0004\"\u0002$\u0001\t\u00039\u0005\"\u0002(\u0001\t\u0003z\u0005\"\u00023\u0001\t\u0003*\u0007\"B>\u0001\t\u0003b\bbBA\u0007\u0001\u0011\u0005\u0013q\u0002\u0005\t\u0003+\u0001A\u0011A\u0007\u0002\u0018\t!\"j]8o)\u0016l\u0007\u000f\\1uK&k\u0007o\u001c:uKJT!AD\b\u0002\r\u0015D\bo\u001c:u\u0015\t\u0001\u0012#A\u0005yYJ,G.Z1tK*\u0011!cE\u0001\nq\u0016\u0014\u0017.\u00197bENT\u0011\u0001F\u0001\u0004G>l7\u0001A\n\u0003\u0001]\u00012\u0001G\r\u001c\u001b\u0005i\u0011B\u0001\u000e\u000e\u0005Q\u0011\u0015m]3UK6\u0004H.\u0019;f\u00136\u0004xN\u001d;feB\u0011\u0001\u0004H\u0005\u0003;5\u00111CS:p]R+W\u000e\u001d7bi\u0016\u001cuN\u001c;f]R\fa\u0003^3na2\fG/Z%na>\u0014H/\u00169he\u0006$WM\u001d\t\u00031\u0001J!!I\u0007\u0003-Q+W\u000e\u001d7bi\u0016LU\u000e]8siV\u0003xM]1eKJ\f\u0011\u0003^1tW\u0006\u001b7-Z:t'\u0016\u0014h/[2f!\t!s%D\u0001&\u0015\t1s\"A\u0004tKJ4\u0018nY3\n\u0005!*#!\u0005+bg.\f5mY3tgN+'O^5dK\u0006q!/\u001a7fCN,7+\u001a:wS\u000e,\u0007C\u0001\u0013,\u0013\taSE\u0001\bSK2,\u0017m]3TKJ4\u0018nY3\u0002W%l\u0007o\u001c:u)\u0016l\u0007\u000f\\1uK\u000e{gNZ5hkJ\fG/[8o\u0013R,WNU3bI\u0016\u0014xK]5uKJ\u0004\"aL\u001b\u000e\u0003AR!AD\u0019\u000b\u0005I\u001a\u0014\u0001\u00039mk6\u0014\u0017N\\4\u000b\u0005Q\n\u0012\u0001\u00033fa2|\u00170\u001b;\n\u0005Y\u0002$aK%na>\u0014H\u000fV3na2\fG/Z\"p]\u001aLw-\u001e:bi&|g.\u0013;f[J+\u0017\rZ3s/JLG/\u001a:\u0002%Q,W\u000e\u001d7bi\u0016\u0004&o\\2fgN|'o\u001d\t\u0004sy\u0002U\"\u0001\u001e\u000b\u0005mb\u0014\u0001B;uS2T\u0011!P\u0001\u0005U\u00064\u0018-\u0003\u0002@u\tAq\n\u001d;j_:\fG\u000eE\u0002:\u0003\u000eK!A\u0011\u001e\u0003\t1K7\u000f\u001e\t\u00031\u0011K!!R\u0007\u0003/Q+W\u000e\u001d7bi\u0016LU\u000e]8siB\u0013xnY3tg>\u0014\u0018A\u0002\u001fj]&$h\b\u0006\u0004I\u0013*[E*\u0014\t\u00031\u0001AQA\b\u0004A\u0002}AQA\t\u0004A\u0002\rBQ!\u000b\u0004A\u0002)BQ!\f\u0004A\u00029BQa\u000e\u0004A\u0002a\n\u0001b];qa>\u0014Ho]\u000b\u0003!n#\"!U,\u0011\u0005I+V\"A*\u000b\u0003Q\u000bQa]2bY\u0006L!AV*\u0003\u000f\t{w\u000e\\3b]\")\u0001l\u0002a\u00013\u0006i\u0011.\u001c9peR\u001cuN\u001c;fqR\u0004\"AW.\r\u0001\u0011)Al\u0002b\u0001;\n\tQ+\u0005\u0002_CB\u0011!kX\u0005\u0003AN\u0013qAT8uQ&tw\r\u0005\u0002\u0019E&\u00111-\u0004\u0002\u0016)\u0016l\u0007\u000f\\1uK&k\u0007o\u001c:u\u0007>tG/\u001a=u\u0003M!wnQ8om\u0016\u0014H\u000fV8UK6\u0004H.\u0019;f)\r1GN\u001c\t\u0003O*l\u0011\u0001\u001b\u0006\u0003S>\ta\u0001Z8nC&t\u0017BA6i\u0005\u001d\u0011V\r\\3bg\u0016DQ!\u001c\u0005A\u0002m\tq\u0002^3na2\fG/Z\"p]R,g\u000e\u001e\u0005\u0006_\"\u0001\r\u0001]\u0001\u0014I\u0016\u001cH/\u001b8bi&|gNR8mI\u0016\u0014\u0018\n\u001a\t\u0003cbt!A\u001d<\u0011\u0005M\u001cV\"\u0001;\u000b\u0005U,\u0012A\u0002\u001fs_>$h(\u0003\u0002x'\u00061\u0001K]3eK\u001aL!!\u001f>\u0003\rM#(/\u001b8h\u0015\t98+A\u000be_J+\u0017\r\u001a+f[Bd\u0017\r^3D_:$XM\u001c;\u0015\tmi\u00181\u0002\u0005\u0006}&\u0001\ra`\u0001\fS:\u0004X\u000f^*ue\u0016\fW\u000e\u0005\u0003\u0002\u0002\u0005\u001dQBAA\u0002\u0015\r\t)\u0001P\u0001\u0003S>LA!!\u0003\u0002\u0004\tY\u0011J\u001c9viN#(/Z1n\u0011\u0015A\u0016\u00021\u0001b\u0003a!w.\u00169he\u0006$W\rV3na2\fG/Z\"p]R,g\u000e\u001e\u000b\u0005\u0003#\t\u0019\u0002E\u0002:\u0003BDQ!\u001c\u0006A\u0002m\t\u0001B]3bI*\u001bxN\u001c\u000b\u0004a\u0006e\u0001\"\u0002@\f\u0001\u0004y\b&B\u0006\u0002\u001e\u0005%\u0002#\u0002*\u0002 \u0005\r\u0012bAA\u0011'\n1A\u000f\u001b:poN\u0004B!!\u0001\u0002&%!\u0011qEA\u0002\u0005-Iu*\u0012=dKB$\u0018n\u001c82\ry\u0001\u00181FA,c%\u0019\u0013QFA\u001b\u0003\u001b\n9$\u0006\u0003\u00020\u0005ER#\u00019\u0005\u000f\u0005MRC1\u0001\u0002>\t\tA+\u0003\u0003\u00028\u0005e\u0012a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$\u0013GC\u0002\u0002<M\u000ba\u0001\u001e5s_^\u001c\u0018c\u00010\u0002@A!\u0011\u0011IA$\u001d\r\u0011\u00161I\u0005\u0004\u0003\u000b\u001a\u0016a\u00029bG.\fw-Z\u0005\u0005\u0003\u0013\nYEA\u0005UQJ|w/\u00192mK*\u0019\u0011QI*2\u0013\r\ny%!\u0015\u0002T\u0005mbb\u0001*\u0002R%\u0019\u00111H*2\u000b\t\u00126+!\u0016\u0003\u000bM\u001c\u0017\r\\12\u0007\u0019\n\u0019\u0003K\u0002\u0001\u00037\u0002B!!\u0018\u0002l5\u0011\u0011q\f\u0006\u0005\u0003C\n\u0019'\u0001\u0006ti\u0016\u0014Xm\u001c;za\u0016TA!!\u001a\u0002h\u0005y1\u000f\u001d:j]\u001e4'/Y7fo>\u00148N\u0003\u0002\u0002j\u0005\u0019qN]4\n\t\u00055\u0014q\f\u0002\n\u0007>l\u0007o\u001c8f]R\u0004")
public class JsonTemplateImporter
extends BaseTemplateImporter<JsonTemplateContent> {
    private final TemplateImportUpgrader templateImportUpgrader;
    private final ImportTemplateConfigurationItemReaderWriter importTemplateConfigurationItemReaderWriter;

    @Override
    public <U extends TemplateImportContext> boolean supports(U importContext) {
        U u = importContext;
        if (u != null) {
            boolean isJson = u.isJson();
            boolean isDefaultTemplate = u.isDefaultTemplate();
            boolean isDsl = u.isDsl();
            return !isDefaultTemplate && isJson && !isDsl;
        }
        return false;
    }

    @Override
    public Release doConvertToTemplate(JsonTemplateContent templateContent, String destinationFolderId) {
        ResolutionContext resolutionContext = ResolutionContext$.MODULE$.apply(destinationFolderId);
        ByteArrayInputStream singleReleaseStream = new ByteArrayInputStream(templateContent.template().toString().getBytes());
        ConfigurationItem configurationItem = this.importTemplateConfigurationItemReaderWriter.readFrom(resolutionContext, MediaType.APPLICATION_JSON_TYPE, singleReleaseStream);
        Checks.checkArgument((boolean)(configurationItem instanceof Release), (String)"Template file doesn't contain a Release", (Object[])new Object[0]);
        return (Release)configurationItem;
    }

    @Override
    public JsonTemplateContent doReadTemplateContent(InputStream inputStream, TemplateImportContext importContext) {
        String jsonString = this.readJson(inputStream);
        JSONArray jsonArray = new JSONArray(jsonString);
        Checks.checkArgument((jsonArray.length() >= 1 ? 1 : 0) != 0, (String)"Template file is empty", (Object[])new Object[0]);
        Checks.checkArgument((boolean)(jsonArray.get(0) instanceof JSONObject), (String)"Invalid json file", (Object[])new Object[0]);
        HashMap<String, LocalFile> localFiles = new HashMap<String, LocalFile>();
        String version = (String)Option$.MODULE$.apply((Object)importContext.version()).getOrElse((Function0 & Serializable)() -> "3.0.0");
        return new JsonTemplateContent((JSONObject)jsonArray.get(0), version, localFiles);
    }

    @Override
    public List<String> doUpgradeTemplateContent(JsonTemplateContent templateContent) {
        return this.templateImportUpgrader.upgrade(templateContent.template(), templateContent.version()).getWarnings();
    }

    public String readJson(InputStream inputStream) throws IOException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream, (int)8192);
        return new String(outputStream.toByteArray());
    }

    public JsonTemplateImporter(TemplateImportUpgrader templateImportUpgrader, TaskAccessService taskAccessService, ReleaseService releaseService, ImportTemplateConfigurationItemReaderWriter importTemplateConfigurationItemReaderWriter, Optional<List<TemplateImportProcessor>> templateProcessors) {
        this.templateImportUpgrader = templateImportUpgrader;
        this.importTemplateConfigurationItemReaderWriter = importTemplateConfigurationItemReaderWriter;
        super(taskAccessService, releaseService, templateProcessors);
    }
}

