/*
 * Decompiled with CFR 0.152.
 */
package com.ryantenney.metrics.spring.reporter;

import com.ryantenney.metrics.spring.reporter.AbstractReporterElementParser;
import com.ryantenney.metrics.spring.reporter.Slf4jReporterFactoryBean;

public class Slf4jReporterElementParser
extends AbstractReporterElementParser {
    protected static final String LOG_LEVEL_STRING_REGEX = "^(?:TRACE|DEBUG|INFO|WARN|ERROR)$";

    @Override
    public String getType() {
        return "slf4j";
    }

    @Override
    protected Class<?> getBeanClass() {
        return Slf4jReporterFactoryBean.class;
    }

    @Override
    protected void validate(AbstractReporterElementParser.ValidationContext c) {
        c.require("period", "^(\\d+)\\s?(ns|us|ms|s|m|h|d)?$", "Period is required and must be in the form '\\d+(ns|us|ms|s|m|h|d)'");
        c.optional("marker");
        c.optional("logger");
        c.optional("level", LOG_LEVEL_STRING_REGEX, "Level must be one of the enum constants from com.codahale.metrics.Slf4jReporter.LoggingLevel");
        c.optional("rate-unit", "^(?:DAY|HOUR|MINUTE|(?:MICRO|MILLI|NANO)?SECOND)S$", "Rate unit must be one of the enum constants from java.util.concurrent.TimeUnit");
        c.optional("duration-unit", "^(?:DAY|HOUR|MINUTE|(?:MICRO|MILLI|NANO)?SECOND)S$", "Duration unit must be one of the enum constants from java.util.concurrent.TimeUnit");
        c.optional("prefix");
        c.optional("prefix-supplier-ref");
        if (c.has("prefix") && c.has("prefix-supplier-ref")) {
            c.reject("prefix-supplier-ref", "Reporter element must not specify both the 'prefix' and 'prefix-supplier-ref' attributes");
        }
        c.optional("filter");
        c.optional("filter-ref");
        if (c.has("filter") && c.has("filter-ref")) {
            c.reject("filter-ref", "Reporter element must not specify both the 'filter' and 'filter-ref' attributes");
        }
        c.rejectUnmatchedProperties();
    }
}

