/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.domain.variables;

import com.google.common.base.Preconditions;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.udm.base.BaseConfigurationItem;
import com.xebialabs.xlplatform.documentation.PublicApiMember;
import com.xebialabs.xlplatform.documentation.PublicApiRef;
import com.xebialabs.xlplatform.documentation.ShowOnlyPublicApiMembers;
import com.xebialabs.xlrelease.api.internal.InternalMetadata;
import com.xebialabs.xlrelease.domain.variables.Variable;
import com.xebialabs.xlrelease.utils.VariableContainerUtils;
import com.xebialabs.xlrelease.variable.VariableHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@Metadata(description="Folder variable container", root=Metadata.ConfigurationItemRoot.APPLICATIONS, versioned=false)
@PublicApiRef
@ShowOnlyPublicApiMembers
public class FolderVariables
extends BaseConfigurationItem
implements InternalMetadata {
    public static final String FOLDER_VARIABLES = "folderVariables";
    public static final String UNSET_VARIABLE_FOLDER_ID = Metadata.ConfigurationItemRoot.APPLICATIONS.getRootNodeName() + "/{folderId}/variables";
    @Property(asContainment=true, required=false, description="List of folder variable CIs")
    private List<Variable> variables = new ArrayList<Variable>();

    public FolderVariables() {
        this.setId(UNSET_VARIABLE_FOLDER_ID);
    }

    public FolderVariables(String folderId, List<Variable> variables) {
        this.setId(folderId + "/variables");
        this.setVariables(variables);
    }

    @PublicApiMember
    public List<Variable> getVariables() {
        return VariableContainerUtils.getVariables(this.variables);
    }

    @PublicApiMember
    public Map<String, String> getStringVariableValues() {
        return VariableHelper.getVariableValuesAsStrings(this.variables);
    }

    @PublicApiMember
    public Map<String, String> getPasswordVariableValues() {
        return VariableHelper.getPasswordVariableValuesAsStrings(this.variables);
    }

    public void setVariables(List<Variable> variables) {
        this.variables = variables;
        VariableContainerUtils.setVariableContainerDefaults(this.variables);
    }

    public Map<String, Variable> getVariablesByKeys() {
        return VariableHelper.indexByKey(this.variables);
    }

    public Variable addVariable(Variable variable) {
        Preconditions.checkNotNull((Object)variable);
        variable.checkFolderVariableValidity();
        Preconditions.checkArgument((!this.getVariablesByKeys().containsKey(variable.getKey()) ? 1 : 0) != 0, (String)"A variable already exists by key '%s'", (Object)variable.getKey());
        VariableContainerUtils.setVariableContainerDefaults(variable);
        this.variables.add(variable);
        return variable;
    }
}

