#
# Copyright (c) 2021. All rights reserved.
#
# This software and all trademarks, trade names, and logos included herein are the property of Digital.ai, Inc. and its affiliates, subsidiaries, and licensors.
#

from argo.kube_client import KubeClient
from argo.commandParams import CommandHelper
import json


try:
    flags = []
    commandline_params = None
    flags = CommandHelper.commandParams(rolloutsConf, flags)

    if flags:
        commandline_params = '%s' % (" ".join(flags) if flags else '')

    values = KubeClient(rolloutsConf['host'], rolloutsConf['kubectlPath'], rolloutsConf['kubectlArgoRolloutPath'],
                        commandline_params).get_rollout_details(rolloutName, namespace)

    #for value in values:
        #print(value)

    data = {}
    revisionIndex = []
    imageIndex = 0
    replicasIndex = 0
    length = len(values)

    for i in range(length):
        value = values[i]
        if "Name:" in value:
            data['name'] = value[value.rfind(' ') + 1:].strip()
        if "Namespace:" in value:
            data['namespace'] = value[value.rfind(' ') + 1:].strip()
        if "Status:" in value:
            data['status'] = value[value.rfind(' ') + 1:].strip()
        if "Strategy:" in value:
            data['strategy'] = value[value.rfind(' ') + 1:].strip()
        if "Step:" in value:
            data['step'] = value[value.rfind(' ') + 1:].strip()
        if "SetWeight:" in value:
            data['setWeight'] = value[value.rfind(' ') + 1:].strip()
        if "ActualWeight:" in value:
            data['actualWeight'] = value[value.rfind(' ') + 1:].strip()
        if "Images:" in value:
            imageIndex = i
        if "Replicas:" in value:
            replicasIndex = i
        if "revision:" in value:
            revisionIndex.append(i)

    step = data['step']
    currentStep = step[:step.find('/')]
    totalStep = step[step.find('/') + 1:]
    data['currentStep'] = currentStep
    data['totalStep'] = totalStep

    revisions = []
    rLength = len(revisionIndex)
    if rLength == 3:
        rLength = 2

    for i in range(0, rLength):
        podsLength = length
        revision = {}
        pods = []
        revisionName = values[revisionIndex[i]].strip()
        revision['revisionName'] = revisionName[revisionName.rfind(' ') + 1:].strip()
        replicaSetInfo = values[revisionIndex[i] + 1].strip()
        replicaSetInfo = replicaSetInfo[replicaSetInfo.rfind(' ') + 1:].strip()
        revision['replicaSetInfo'] = replicaSetInfo
        imageName = ''
        for k in range(imageIndex, replicasIndex):
            if '(' + replicaSetInfo + ')' in values[k]:
                value = values[k].strip()
                if "Images:" in value:
                    value = value[value.find(' ') + 1:].strip()
                if imageName == '':
                    imageName = value
                else:
                    imageName = imageName + ', ' + value
        revision['imageName'] = imageName
        replicaSet = values[revisionIndex[i] + 1].strip()
        replicaSet = replicaSet[:replicaSet.find('ReplicaSet')].strip()
        revision['replicaSet'] = replicaSet[replicaSet.rfind(' ') + 1:].strip()
        if len(revisionIndex) > i + 1:
            podsLength = revisionIndex[i + 1]
        for j in range(revisionIndex[i] + 2, podsLength):
            pod = {}
            podDetails = values[j]
            podName = podDetails[:podDetails.find('Pod')].strip()
            podName = podName[podName.rfind(' ') + 1:].strip()
            pod['name'] = podName;
            podStatus = podDetails[podDetails.find('Pod') + 4:].strip()
            podStatus = podStatus[podStatus.find(' ') + 1:].strip()
            podStatus = podStatus[:podStatus.find(' ')].strip()
            pod['status'] = podStatus;
            if 'Init' in pod['status']:
                pod['cssClass'] = 'argorollout-pod-orange'
            elif 'PodInitializing' in pod['status']:
                pod['cssClass'] = 'argorollout-pod-orange'
            elif 'Running' in pod['status']:
                pod['cssClass'] = 'argorollout-pod-green'
            else:
                pod['cssClass'] = 'argorollout-pod-red'
            pods.append(pod)
        revision['pods'] = pods
        revisions.append(revision)

    data['revisions'] = revisions

    command = "get rollout -n %s %s --output=json" % (namespace, rolloutName)
    response = KubeClient(rolloutsConf['host'], rolloutsConf['kubectlPath'], rolloutsConf['kubectlArgoRolloutPath'],
                          commandline_params).execute_command(command)
    #print(response)
    output = json.loads(response)
    data["strategyDetails"] = output["spec"]["strategy"]
    #json_object = json.dumps(data, indent=4)
    #print(json_object)

except Exception as e:
    msg = str(e)
    print("Exception occurred: {0} ".format(msg))
    data = {'error':  msg[:300]}

