/*
 * Decompiled with CFR 0.152.
 */
package org.rzo.yajsw.util;

import com.sun.jna.PlatformEx;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.util.Iterator;
import java.util.logging.Logger;
import org.apache.commons.configuration2.BaseConfiguration;
import org.apache.commons.configuration2.Configuration;
import org.rzo.yajsw.wrapper.WrappedProcess;
import org.rzo.yajsw.wrapper.WrappedService;

public class Utils {
    WrappedProcess _process;
    WrappedService _service;

    public Utils(WrappedProcess process) {
        this._process = process;
    }

    public Utils(WrappedService service) {
        this._service = service;
    }

    public static Configuration toBaseConfiguration(Configuration conf) {
        BaseConfiguration result = new BaseConfiguration();
        if (conf != null && conf.size() > 0) {
            Iterator it = conf.getKeys();
            while (it.hasNext()) {
                String key = (String)it.next();
                result.addProperty(key, conf.getProperty(key));
            }
        }
        return result;
    }

    public String inquireCLI(String message) throws IOException {
        System.out.print(message + ":");
        return new BufferedReader(new InputStreamReader(System.in)).readLine();
    }

    public String inquireTrayIcon(String message) throws InterruptedException {
        String result = null;
        if (this._process == null) {
            System.out.println("ERROR in inquireTrayIcon: process == null");
            return null;
        }
        while (result == null) {
            result = this._process.getTrayIcon().inquire(message);
            if (result != null) continue;
            Thread.sleep(2000L);
        }
        return result;
    }

    public static InetAddress getLoopbackAddress() throws Exception {
        if (Boolean.getBoolean("java.net.preferIPv6Stack")) {
            byte[] arg0 = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1};
            return InetAddress.getByAddress("localhost", arg0);
        }
        byte[] arg0 = new byte[]{127, 0, 0, 1};
        return InetAddress.getByAddress("localhost", arg0);
    }

    public static void verifyIPv4IsPreferred(Logger log) {
        boolean ipv4Preferred = Boolean.getBoolean("java.net.preferIPv4Stack");
        boolean isJDK7 = System.getProperty("java.version").startsWith("1.7");
        boolean isWindows = PlatformEx.isWinVista();
        if (isWindows && isJDK7 && !ipv4Preferred) {
            if (log != null) {
                log.warning("!! WARNING !! Windows JDK7 should set -Djava.net.preferIPv4Stack=true (see java bug 7179799 )");
            } else {
                System.out.println("!! WARNING !! Windows JDK7 should set -Djava.net.preferIPv4Stack=true (see java bug 7179799 )");
            }
        }
    }

    public static boolean requiredRTjar() {
        String jvm = System.getProperty("java.version");
        return jvm.startsWith("1.");
    }

    public static String getDOption(String key, String value) {
        if (value == null) {
            System.out.println("null d option: " + key);
            return null;
        }
        value = value.replaceAll("\"", "");
        return "-D" + key + "=" + value;
    }

    public static int parseOctal(String txt) {
        int result = -1;
        if (txt != null) {
            try {
                result = Integer.parseInt(txt, 8);
            }
            catch (Exception ex) {
                System.out.println(ex + " " + ex.getMessage());
            }
        }
        return result;
    }
}

