/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.svn.ssh.apache;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyPair;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.sshd.client.SshClient;
import org.apache.sshd.client.config.hosts.DefaultConfigFileHostEntryResolver;
import org.apache.sshd.client.config.hosts.HostConfigEntryResolver;
import org.apache.sshd.client.future.ConnectFuture;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.common.config.keys.FilePasswordProvider;
import org.apache.sshd.common.io.IoServiceFactoryFactory;
import org.apache.sshd.common.io.nio2.Nio2ServiceFactoryFactory;
import org.apache.sshd.common.util.security.SecurityUtils;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.auth.ISVNSSHHostVerifier;
import org.tmatesoft.svn.core.internal.io.svn.ssh.apache.ApacheSshSession;
import org.tmatesoft.svn.core.internal.io.svn.ssh.apache.SshHost;

public class SshConnection {
    private static final Logger log = Logger.getLogger(SshConnection.class.getName());
    private final SshClient client;
    private final SshHost host;
    private ClientSession session;
    private long lastAccessTime = System.currentTimeMillis();
    private int sessionCount;

    public SshConnection(SshHost host) throws Exception {
        this.host = host;
        this.client = SshClient.setUpDefaultClient();
        this.client.setIoServiceFactoryFactory((IoServiceFactoryFactory)new Nio2ServiceFactoryFactory());
        byte[] privateKey = host.getPrivateKey();
        if (privateKey != null) {
            Iterable keyPairs = SecurityUtils.loadKeyPairIdentities(null, () -> "private key", (InputStream)new ByteArrayInputStream(privateKey), (FilePasswordProvider)FilePasswordProvider.of((String)host.getPrivateKeyPassphrase()));
            if (!keyPairs.iterator().hasNext()) {
                throw new RuntimeException("Did not find a keypair in the provided private key string: " + privateKey);
            }
            this.client.addPublicKeyIdentity((KeyPair)keyPairs.iterator().next());
        }
        if (host.getPassword() != null) {
            this.client.addPasswordIdentity(host.getPassword());
        }
        this.client.setServerKeyVerifier((clientSession, remoteAddress, serverKey) -> {
            try {
                ISVNSSHHostVerifier verifier = host.getHostVerifier();
                if (verifier != null) {
                    verifier.verifyHostKey(host.getHostName(), host.getPort(), serverKey.getAlgorithm(), serverKey.getEncoded());
                }
                return true;
            }
            catch (SVNException e) {
                log.log(Level.SEVERE, "Failed while verifying host key: " + host.getKey(), e);
                return false;
            }
        });
        this.client.setHostConfigEntryResolver((HostConfigEntryResolver)DefaultConfigFileHostEntryResolver.INSTANCE);
        try {
            this.client.start();
            ConnectFuture connectFuture = this.client.connect(host.getUserName(), host.getHostName(), host.getPort());
            connectFuture.await();
            this.session = connectFuture.getClientSession();
            this.session.auth().verify(10000L);
        }
        catch (Exception e) {
            this.client.close();
            throw e;
        }
    }

    public ApacheSshSession openSession() throws IOException {
        ++this.sessionCount;
        return new ApacheSshSession(this);
    }

    public void sessionClosed(ApacheSshSession sshSession) {
        this.lastAccessTime = System.currentTimeMillis();
        --this.sessionCount;
    }

    public int getSessionsCount() {
        return this.sessionCount;
    }

    public void close() {
        if (this.session != null) {
            this.session.close(false);
            this.session = null;
        }
        this.client.stop();
        this.sessionCount = 0;
    }

    public long lastAcccessTime() {
        return this.lastAccessTime;
    }

    public ClientSession getSession() {
        return this.session;
    }

    public SshConnection reOpen() throws IOException {
        try {
            return new SshConnection(this.host);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException("Failed to reopen connection");
        }
    }
}

