/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.integration.util;

import com.synopsys.integration.util.TokenizerUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class ExcludedIncludedFilter {
    public static final ExcludedIncludedFilter EMPTY = new ExcludedIncludedFilter(Collections.emptyList(), Collections.emptyList());
    protected final Set<String> excludedSet;
    protected final Set<String> includedSet;

    public static ExcludedIncludedFilter fromCommaSeparatedStrings(String toExclude, String toInclude) {
        return new ExcludedIncludedFilter(TokenizerUtils.createSetFromString(toExclude), TokenizerUtils.createSetFromString(toInclude));
    }

    public static ExcludedIncludedFilter fromCollections(Collection<String> toExclude, Collection<String> toInclude) {
        return new ExcludedIncludedFilter(toExclude, toInclude);
    }

    protected ExcludedIncludedFilter(Collection<String> toExcludeList, Collection<String> toIncludeList) {
        this.excludedSet = new HashSet<String>(toExcludeList);
        this.includedSet = new HashSet<String>(toIncludeList);
    }

    public boolean willExclude(String itemName) {
        return this.excludedSet.contains(itemName);
    }

    public boolean willInclude(String itemName) {
        return this.includedSet.isEmpty() || this.includedSet.contains(itemName);
    }

    public final boolean shouldInclude(String itemName) {
        if (this.willExclude(itemName)) {
            return false;
        }
        return this.willInclude(itemName);
    }
}

