/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.core.endpoint;

import java.io.Serializable;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import org.springframework.security.oauth2.core.AuthorizationGrantType;
import org.springframework.security.oauth2.core.endpoint.OAuth2AuthorizationResponseType;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.util.DefaultUriBuilderFactory;
import org.springframework.web.util.UriBuilder;
import org.springframework.web.util.UriUtils;

public final class OAuth2AuthorizationRequest
implements Serializable {
    private static final long serialVersionUID = 570L;
    private String authorizationUri;
    private AuthorizationGrantType authorizationGrantType;
    private OAuth2AuthorizationResponseType responseType;
    private String clientId;
    private String redirectUri;
    private Set<String> scopes;
    private String state;
    private Map<String, Object> additionalParameters;
    private String authorizationRequestUri;
    private Map<String, Object> attributes;

    private OAuth2AuthorizationRequest() {
    }

    public String getAuthorizationUri() {
        return this.authorizationUri;
    }

    public AuthorizationGrantType getGrantType() {
        return this.authorizationGrantType;
    }

    public OAuth2AuthorizationResponseType getResponseType() {
        return this.responseType;
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getRedirectUri() {
        return this.redirectUri;
    }

    public Set<String> getScopes() {
        return this.scopes;
    }

    public String getState() {
        return this.state;
    }

    public Map<String, Object> getAdditionalParameters() {
        return this.additionalParameters;
    }

    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    public <T> T getAttribute(String name) {
        return (T)this.getAttributes().get(name);
    }

    public String getAuthorizationRequestUri() {
        return this.authorizationRequestUri;
    }

    public static Builder authorizationCode() {
        return new Builder(AuthorizationGrantType.AUTHORIZATION_CODE);
    }

    @Deprecated
    public static Builder implicit() {
        return new Builder(AuthorizationGrantType.IMPLICIT);
    }

    public static Builder from(OAuth2AuthorizationRequest authorizationRequest) {
        Assert.notNull((Object)authorizationRequest, (String)"authorizationRequest cannot be null");
        return new Builder(authorizationRequest.getGrantType()).authorizationUri(authorizationRequest.getAuthorizationUri()).clientId(authorizationRequest.getClientId()).redirectUri(authorizationRequest.getRedirectUri()).scopes(authorizationRequest.getScopes()).state(authorizationRequest.getState()).additionalParameters(authorizationRequest.getAdditionalParameters()).attributes(authorizationRequest.getAttributes());
    }

    public static final class Builder {
        private String authorizationUri;
        private AuthorizationGrantType authorizationGrantType;
        private OAuth2AuthorizationResponseType responseType;
        private String clientId;
        private String redirectUri;
        private Set<String> scopes;
        private String state;
        private Map<String, Object> additionalParameters = new LinkedHashMap<String, Object>();
        private Consumer<Map<String, Object>> parametersConsumer = params -> {};
        private Map<String, Object> attributes = new LinkedHashMap<String, Object>();
        private String authorizationRequestUri;
        private Function<UriBuilder, URI> authorizationRequestUriFunction = builder -> builder.build(new Object[0]);
        private final DefaultUriBuilderFactory uriBuilderFactory;

        private Builder(AuthorizationGrantType authorizationGrantType) {
            Assert.notNull((Object)authorizationGrantType, (String)"authorizationGrantType cannot be null");
            this.authorizationGrantType = authorizationGrantType;
            if (AuthorizationGrantType.AUTHORIZATION_CODE.equals(authorizationGrantType)) {
                this.responseType = OAuth2AuthorizationResponseType.CODE;
            } else if (AuthorizationGrantType.IMPLICIT.equals(authorizationGrantType)) {
                this.responseType = OAuth2AuthorizationResponseType.TOKEN;
            }
            this.uriBuilderFactory = new DefaultUriBuilderFactory();
            this.uriBuilderFactory.setEncodingMode(DefaultUriBuilderFactory.EncodingMode.NONE);
        }

        public Builder authorizationUri(String authorizationUri) {
            this.authorizationUri = authorizationUri;
            return this;
        }

        public Builder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public Builder redirectUri(String redirectUri) {
            this.redirectUri = redirectUri;
            return this;
        }

        public Builder scope(String ... scope) {
            if (scope != null && scope.length > 0) {
                return this.scopes(new LinkedHashSet<String>(Arrays.asList(scope)));
            }
            return this;
        }

        public Builder scopes(Set<String> scopes) {
            this.scopes = scopes;
            return this;
        }

        public Builder state(String state) {
            this.state = state;
            return this;
        }

        public Builder additionalParameters(Map<String, Object> additionalParameters) {
            if (!CollectionUtils.isEmpty(additionalParameters)) {
                this.additionalParameters.putAll(additionalParameters);
            }
            return this;
        }

        public Builder additionalParameters(Consumer<Map<String, Object>> additionalParametersConsumer) {
            if (additionalParametersConsumer != null) {
                additionalParametersConsumer.accept(this.additionalParameters);
            }
            return this;
        }

        public Builder parameters(Consumer<Map<String, Object>> parametersConsumer) {
            if (parametersConsumer != null) {
                this.parametersConsumer = parametersConsumer;
            }
            return this;
        }

        public Builder attributes(Map<String, Object> attributes) {
            if (!CollectionUtils.isEmpty(attributes)) {
                this.attributes.putAll(attributes);
            }
            return this;
        }

        public Builder attributes(Consumer<Map<String, Object>> attributesConsumer) {
            if (attributesConsumer != null) {
                attributesConsumer.accept(this.attributes);
            }
            return this;
        }

        public Builder authorizationRequestUri(String authorizationRequestUri) {
            this.authorizationRequestUri = authorizationRequestUri;
            return this;
        }

        public Builder authorizationRequestUri(Function<UriBuilder, URI> authorizationRequestUriFunction) {
            if (authorizationRequestUriFunction != null) {
                this.authorizationRequestUriFunction = authorizationRequestUriFunction;
            }
            return this;
        }

        public OAuth2AuthorizationRequest build() {
            Assert.hasText((String)this.authorizationUri, (String)"authorizationUri cannot be empty");
            Assert.hasText((String)this.clientId, (String)"clientId cannot be empty");
            if (AuthorizationGrantType.IMPLICIT.equals(this.authorizationGrantType)) {
                Assert.hasText((String)this.redirectUri, (String)"redirectUri cannot be empty");
            }
            OAuth2AuthorizationRequest authorizationRequest = new OAuth2AuthorizationRequest();
            authorizationRequest.authorizationUri = this.authorizationUri;
            authorizationRequest.authorizationGrantType = this.authorizationGrantType;
            authorizationRequest.responseType = this.responseType;
            authorizationRequest.clientId = this.clientId;
            authorizationRequest.redirectUri = this.redirectUri;
            authorizationRequest.state = this.state;
            authorizationRequest.scopes = Collections.unmodifiableSet(CollectionUtils.isEmpty(this.scopes) ? Collections.emptySet() : new LinkedHashSet<String>(this.scopes));
            authorizationRequest.additionalParameters = Collections.unmodifiableMap(this.additionalParameters);
            authorizationRequest.attributes = Collections.unmodifiableMap(this.attributes);
            authorizationRequest.authorizationRequestUri = StringUtils.hasText((String)this.authorizationRequestUri) ? this.authorizationRequestUri : this.buildAuthorizationRequestUri();
            return authorizationRequest;
        }

        private String buildAuthorizationRequestUri() {
            Map<String, Object> parameters = this.getParameters();
            this.parametersConsumer.accept(parameters);
            LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
            parameters.forEach((arg_0, arg_1) -> Builder.lambda$buildAuthorizationRequestUri$2((MultiValueMap)queryParams, arg_0, arg_1));
            UriBuilder uriBuilder = this.uriBuilderFactory.uriString(this.authorizationUri).queryParams((MultiValueMap)queryParams);
            return this.authorizationRequestUriFunction.apply(uriBuilder).toString();
        }

        private Map<String, Object> getParameters() {
            LinkedHashMap<String, Object> parameters = new LinkedHashMap<String, Object>();
            parameters.put("response_type", this.responseType.getValue());
            parameters.put("client_id", this.clientId);
            if (!CollectionUtils.isEmpty(this.scopes)) {
                parameters.put("scope", StringUtils.collectionToDelimitedString(this.scopes, (String)" "));
            }
            if (this.state != null) {
                parameters.put("state", this.state);
            }
            if (this.redirectUri != null) {
                parameters.put("redirect_uri", this.redirectUri);
            }
            parameters.putAll(this.additionalParameters);
            return parameters;
        }

        private static String encodeQueryParam(String value) {
            return UriUtils.encodeQueryParam((String)value, (Charset)StandardCharsets.UTF_8);
        }

        private static /* synthetic */ void lambda$buildAuthorizationRequestUri$2(MultiValueMap queryParams, String k, Object v) {
            queryParams.set((Object)Builder.encodeQueryParam(k), (Object)Builder.encodeQueryParam(String.valueOf(v)));
        }
    }
}

