import React from 'react';
import { ReactWrapper } from 'enzyme';
import noop from 'lodash/noop';
import { mountWithStoreAndTheme } from '../../../../../../../../../../../core/xlr-ui/tests/unit/testing-utils';
import { mockDeployWebhookEventSource } from '../../../__mocks__/external-deployments.mocks';
import { folderExternalDeployments, FolderExternalDeploymentsState, initialState } from '../../../ducks/external-deployments.reducer';
import { IMG_SRC } from '../../../constants';
import { EventSourceForm } from './application-event-source.component';

const { loadFilterEventSource } = folderExternalDeployments.actions;
const dispatch = jest.fn();

describe('EventSourceForm component', () => {
    let wrapper: ReactWrapper;
    const defaultProps = {
        closeForm: () => noop(),
        eventSourceId: mockDeployWebhookEventSource.id!,
    };
    const defaultState = {
        ...initialState,
    };
    const mountComponent = (state: FolderExternalDeploymentsState = defaultState) => {
        wrapper = mountWithStoreAndTheme(<EventSourceForm {...defaultProps} />, dispatch, { folderExternalDeployments: state });
        expect(dispatch).toBeCalledWith(loadFilterEventSource(mockDeployWebhookEventSource.id!));
    };

    beforeEach(() => {
        mountComponent();
    });

    afterEach(() => {
        wrapper.unmount();
    });

    const searchDotCard = (selector: string) => wrapper.find(`.event-source-form ${selector}`);

    it('should show the header', () => {
        expect(searchDotCard('.dot-typography img').at(0).props().src).toStrictEqual(IMG_SRC.webhookSource);
        expect(searchDotCard('.dot-typography').at(0).text()).toStrictEqual('Endpoint webhook');
    });

    it('should show form fields', () => {
        expect(searchDotCard('[name="eventSourceName"] input')).toHaveLength(1);
        expect(searchDotCard('[name="enableEventSource"] input')).toHaveLength(1);
        expect(searchDotCard('[name="endpointPath"] input')).toHaveLength(1);
        expect(searchDotCard('[name="requestRetention"] input')).toHaveLength(1);
        expect(searchDotCard('[name="Authentication method"] input')).toHaveLength(1);
    });

    it('should show buttons', () => {
        expect(searchDotCard('.dot-button button').at(0).text()).toStrictEqual('Cancel');
        expect(searchDotCard('.dot-button button').at(1).text()).toStrictEqual('Save');
    });
});
