import React, { MouseEvent, useState } from 'react';
import { DotButton, DotIcon, DotIconButton, DotMenu } from '@digital-ai/dot-components';
import { ActionToolbarPortalContainer } from '../../../../../../../../../core/xlr-ui/app/features/main-navigation/action-toolbar/components/action-toolbar.portal';
import { Folder } from '../../../../../../../../../core/xlr-ui/app/types';
import { useAppDispatch } from '../../../../../../../../../core/xlr-ui/app/js/hooks';
import { folderExternalDeployments } from '../ducks/external-deployments.reducer';

export interface ApplicationsTableComponentPortalProp {
    folder: Folder;
    onViewChange: () => void;
    openApplicationSources: () => void;
    reSyncEnabled: boolean;
}

const { refreshExternalDeployments } = folderExternalDeployments.actions;

export const ExternalDeploymentComponentPortal = (props: ApplicationsTableComponentPortalProp) => {
    const { onViewChange, openApplicationSources, reSyncEnabled } = props;

    const [isMenuOpen, setIsMenuOpen] = useState<boolean>(false);
    const [menuAnchorEl, setMenuAnchorEl] = useState<HTMLElement | null>(null);

    const dispatch = useAppDispatch();

    const toggleMenu = (event: MouseEvent<HTMLElement>) => {
        setMenuAnchorEl(event.currentTarget);
        setIsMenuOpen(!isMenuOpen);
    };
    return (
        <ActionToolbarPortalContainer>
            <DotButton disabled={!reSyncEnabled} onClick={() => dispatch(refreshExternalDeployments())} startIcon={<DotIcon iconId="sync" />} type="outlined">
                Re-sync
            </DotButton>
            <DotButton onClick={() => onViewChange()}> Discover applications </DotButton>

            <>
                <DotIconButton data-testid="application-deployments-menu" iconId="options" onClick={toggleMenu} />
                <DotMenu
                    anchorEl={menuAnchorEl || undefined}
                    dense
                    id="application-deployments-option"
                    menuItems={[
                        {
                            children: 'Applications sources',
                            key: 'Applications sources',
                        },
                    ]}
                    menuPlacement="bottom"
                    open={isMenuOpen}
                    onLeave={() => setIsMenuOpen(false)}
                    onSelect={() => openApplicationSources()}
                />
            </>
        </ActionToolbarPortalContainer>
    );
};
