/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.integration.phonehome.google.analytics;

import com.google.gson.Gson;
import com.synopsys.integration.phonehome.google.analytics.GoogleAnalyticsRequestTransformer;
import com.synopsys.integration.phonehome.request.PhoneHomeRequestBody;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.entity.StringEntity;
import org.apache.http.message.BasicNameValuePair;

public class GoogleAnalyticsRequestHelper {
    private final Gson gson;

    public GoogleAnalyticsRequestHelper(Gson gson) {
        this.gson = gson;
    }

    public HttpPost createRequest(PhoneHomeRequestBody phoneHomeRequestBody) throws UnsupportedEncodingException {
        return this.createRequest(phoneHomeRequestBody, null, "UA-116682967-1");
    }

    public HttpPost createRequest(PhoneHomeRequestBody phoneHomeRequestBody, String url) throws UnsupportedEncodingException {
        return this.createRequest(phoneHomeRequestBody, url, "UA-116682967-1");
    }

    public HttpPost createRequest(PhoneHomeRequestBody phoneHomeRequestBody, String url, String trackingId) throws UnsupportedEncodingException {
        UrlEncodedFormEntity entity;
        GoogleAnalyticsRequestTransformer transformer = new GoogleAnalyticsRequestTransformer(this.gson, trackingId, phoneHomeRequestBody);
        List<NameValuePair> parameters = transformer.getParameters();
        String requestUrl = url;
        List<String> artifactModules = phoneHomeRequestBody.getArtifactModules();
        if (artifactModules == null || artifactModules.size() == 0) {
            if (StringUtils.isBlank((CharSequence)requestUrl)) {
                requestUrl = "https://www.google-analytics.com/collect";
            }
            entity = new UrlEncodedFormEntity(parameters);
        } else {
            String requestString = artifactModules.stream().map(module -> this.createModuleParameters(parameters, (String)module)).map(moduleParameters -> URLEncodedUtils.format((Iterable)moduleParameters, (Charset)StandardCharsets.ISO_8859_1)).collect(Collectors.joining("\n"));
            if (StringUtils.isBlank((CharSequence)requestUrl)) {
                requestUrl = "https://www.google-analytics.com/batch";
            }
            entity = new StringEntity(requestString, StandardCharsets.ISO_8859_1);
        }
        return this.createRequest(requestUrl, (HttpEntity)entity);
    }

    public HttpPost createRequest(String url, HttpEntity httpEntity) {
        HttpPost post = new HttpPost(url);
        post.setEntity(httpEntity);
        return post;
    }

    private List<NameValuePair> createModuleParameters(List<NameValuePair> parameters, String module) {
        BasicNameValuePair parameter = new BasicNameValuePair("cd8", module);
        ArrayList<NameValuePair> newParameters = new ArrayList<NameValuePair>(parameters);
        newParameters.add((NameValuePair)parameter);
        return newParameters;
    }
}

