/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.integration.blackduck.developermode;

import com.synopsys.integration.blackduck.api.manual.view.DeveloperScanComponentResultView;
import com.synopsys.integration.blackduck.developermode.DeveloperScanWaitJobTask;
import com.synopsys.integration.blackduck.exception.BlackDuckIntegrationException;
import com.synopsys.integration.blackduck.service.BlackDuckApiClient;
import com.synopsys.integration.exception.IntegrationException;
import com.synopsys.integration.log.IntLogger;
import com.synopsys.integration.rest.HttpUrl;
import com.synopsys.integration.wait.WaitJob;
import com.synopsys.integration.wait.WaitJobTask;
import java.util.List;

public class RapidScanWaiter {
    private IntLogger logger;
    private BlackDuckApiClient blackDuckApiClient;

    public RapidScanWaiter(IntLogger logger, BlackDuckApiClient blackDuckApiClient) {
        this.logger = logger;
        this.blackDuckApiClient = blackDuckApiClient;
    }

    public List<DeveloperScanComponentResultView> checkScanResult(HttpUrl url, long timeoutInSeconds, int waitIntervalInSeconds) throws IntegrationException, InterruptedException {
        DeveloperScanWaitJobTask waitTask = new DeveloperScanWaitJobTask(this.blackDuckApiClient, url);
        boolean allCompleted = waitTask.isComplete();
        if ((long)waitIntervalInSeconds > timeoutInSeconds) {
            waitIntervalInSeconds = (int)timeoutInSeconds;
        }
        if (!allCompleted) {
            WaitJob waitJob = WaitJob.create(this.logger, timeoutInSeconds, System.currentTimeMillis(), waitIntervalInSeconds, (WaitJobTask)waitTask);
            allCompleted = waitJob.waitFor();
        }
        if (!allCompleted) {
            throw new BlackDuckIntegrationException("Error getting developer scan result. Timeout may have occurred.");
        }
        return this.blackDuckApiClient.getAllResponses(url, DeveloperScanComponentResultView.class);
    }
}

