/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.domain.delivery.conditions;

import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.xlplatform.documentation.PublicApiRef;
import com.xebialabs.xlplatform.documentation.ShowOnlyPublicApiMembers;
import com.xebialabs.xlrelease.domain.delivery.Condition;
import com.xebialabs.xlrelease.domain.delivery.Delivery;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

@Metadata(versioned=false, description="Composite condition comprised of multiple conditions joined by an AND or OR operator.")
@PublicApiRef
@ShowOnlyPublicApiMembers
public class ConditionGroup
extends Condition {
    @Property(category="input", description="Operator to apply when merging the child conditions.")
    private Operator operator;
    @Property(asContainment=true, description="Nested conditions.")
    private List<Condition> conditions = new ArrayList<Condition>();

    @Override
    public List<Condition> markAsSatisfied(String conditionId, Date satisfiedDate) {
        List<Condition> changes = this.conditions.stream().flatMap(condition -> condition.markAsSatisfied(conditionId, satisfiedDate).stream()).collect(Collectors.toList());
        if (this.isActive() && (this.operator == Operator.OR && this.conditions.stream().anyMatch(Condition::isSatisfied) || this.operator == Operator.AND && this.conditions.stream().allMatch(Condition::isSatisfied))) {
            this.setSatisfied(true);
            this.setSatisfiedDate(satisfiedDate);
            changes.add(this);
        }
        return changes;
    }

    @Override
    public String getDescription() {
        return this.conditions.stream().map(Condition::getDescription).collect(Collectors.joining(" " + this.operator.getValue() + " "));
    }

    @Override
    public void validate(Delivery delivery) {
        this.conditions.forEach(condition -> condition.validate(delivery));
    }

    public void addCondition(Condition condition) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<Condition>();
        }
        this.conditions.add(condition);
    }

    public ConditionGroup withOperator(Operator operator) {
        this.operator = operator;
        return this;
    }

    public ConditionGroup withCondition(Condition condition) {
        this.addCondition(condition);
        return this;
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    public List<Condition> getAllConditions() {
        ArrayList<Condition> allConditions = new ArrayList<Condition>(super.getAllConditions());
        this.conditions.forEach(child -> allConditions.addAll(child.getAllConditions()));
        return allConditions;
    }

    @Override
    public List<Condition> getLeafConditions() {
        return this.conditions.stream().flatMap(condition -> condition.getLeafConditions().stream()).collect(Collectors.toList());
    }

    public Operator getOperator() {
        return this.operator;
    }

    public void setOperator(Operator operator) {
        this.operator = operator;
    }

    public List<Condition> getConditions() {
        return this.conditions;
    }

    public void setConditions(List<Condition> conditions) {
        this.conditions = conditions;
    }

    public static enum Operator {
        AND("AND"),
        OR("OR");

        private String value;

        private Operator(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }
}

