/*
 * Decompiled with CFR 0.152.
 */
package org.jparsec;

import org.jparsec.error.Location;
import org.jparsec.internal.annotations.Private;
import org.jparsec.internal.util.IntList;

final class SourceLocator {
    private static final char LINE_BREAK = '\n';
    private final CharSequence source;
    @Private
    final IntList lineBreakIndices = new IntList(20);
    private final int startLineNumber;
    private final int startColumnNumber;
    @Private
    int nextIndex = 0;
    @Private
    int nextColumnIndex = 0;

    SourceLocator(CharSequence source) {
        this(source, 1, 1);
    }

    @Private
    SourceLocator(CharSequence source, int lineNumber, int columnNumber) {
        this.source = source;
        this.startLineNumber = lineNumber;
        this.startColumnNumber = columnNumber;
    }

    Location locate(int index) {
        return index < this.nextIndex ? this.lookup(index) : this.scanTo(index);
    }

    @Private
    Location lookup(int index) {
        int size = this.lineBreakIndices.size();
        if (size == 0) {
            return this.location(0, index);
        }
        int lineNumber = SourceLocator.binarySearch(this.lineBreakIndices, index);
        if (lineNumber == 0) {
            return this.location(0, index);
        }
        int previousBreak = this.lineBreakIndices.get(lineNumber - 1);
        return this.location(lineNumber, index - previousBreak - 1);
    }

    @Private
    Location scanTo(int index) {
        boolean eof = false;
        if (index == this.source.length()) {
            eof = true;
            --index;
        }
        int columnIndex = this.nextColumnIndex;
        for (int i = this.nextIndex; i <= index; ++i) {
            char c = this.source.charAt(i);
            if (c == '\n') {
                this.lineBreakIndices.add(i);
                columnIndex = 0;
                continue;
            }
            ++columnIndex;
        }
        this.nextIndex = index + 1;
        this.nextColumnIndex = columnIndex;
        int lines = this.lineBreakIndices.size();
        if (eof) {
            return this.location(lines, columnIndex);
        }
        if (columnIndex == 0) {
            return this.getLineBreakLocation(lines - 1);
        }
        return this.location(lines, columnIndex - 1);
    }

    private int getLineBreakColumnIndex(int lineIndex) {
        int lineBreakIndex = this.lineBreakIndices.get(lineIndex);
        return lineIndex == 0 ? lineBreakIndex : lineBreakIndex - this.lineBreakIndices.get(lineIndex - 1) - 1;
    }

    private Location getLineBreakLocation(int lineIndex) {
        return this.location(lineIndex, this.getLineBreakColumnIndex(lineIndex));
    }

    private Location location(int l, int c) {
        return new Location(this.startLineNumber + l, (l == 0 ? this.startColumnNumber : 1) + c);
    }

    @Private
    static int binarySearch(IntList ascendingInts, int value) {
        int begin = 0;
        int to = ascendingInts.size();
        while (begin != to) {
            int i = (begin + to) / 2;
            int x = ascendingInts.get(i);
            if (x == value) {
                return i;
            }
            if (x > value) {
                to = i;
                continue;
            }
            begin = i + 1;
        }
        return begin;
    }
}

