/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.risk.service;

import com.xebialabs.xlrelease.config.XlrConfig;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.events.ReleaseCreatedEvent;
import com.xebialabs.xlrelease.domain.events.ReleaseOverdueEvent;
import com.xebialabs.xlrelease.domain.events.ReleaseUpdatedEvent;
import com.xebialabs.xlrelease.domain.events.TaskAbortedEvent;
import com.xebialabs.xlrelease.domain.events.TaskCompletedEvent;
import com.xebialabs.xlrelease.domain.events.TaskDeletedEvent;
import com.xebialabs.xlrelease.domain.events.TaskFailedEvent;
import com.xebialabs.xlrelease.domain.events.TaskOverdueEvent;
import com.xebialabs.xlrelease.domain.events.TaskSkippedEvent;
import com.xebialabs.xlrelease.domain.events.TaskUpdatedEvent;
import com.xebialabs.xlrelease.events.EventListener;
import com.xebialabs.xlrelease.events.Subscribe;
import com.xebialabs.xlrelease.events.SynchronizedSubscribe;
import com.xebialabs.xlrelease.repository.ConfigurationRepository;
import com.xebialabs.xlrelease.risk.domain.RiskProfile;
import com.xebialabs.xlrelease.risk.domain.events.RiskProfileUpdated;
import com.xebialabs.xlrelease.risk.service.RiskService;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.concurrent.Executor;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import scala.Function0;
import scala.reflect.ScalaSignature;

@Service
@EventListener
@ScalaSignature(bytes="\u0006\u0005\u0005Eg\u0001B\n\u0015\u0001}A\u0001B\f\u0001\u0003\u0002\u0003\u0006Ia\f\u0005\tk\u0001\u0011\t\u0011)A\u0005m!AA\b\u0001B\u0001B\u0003%Q\b\u0003\u0005B\u0001\t\u0005\t\u0015!\u0003C\u0011\u0015a\u0005\u0001\"\u0001N\u0011\u0015\u0011\u0007\u0001\"\u0001d\u0011\u00159\b\u0001\"\u0001y\u0011\u0019y\b\u0001\"\u0001\u0002\u0002!9\u0011q\u0002\u0001\u0005\u0002\u0005E\u0001bBA\u0010\u0001\u0011\u0005\u0011\u0011\u0005\u0005\b\u0003_\u0001A\u0011AA\u0019\u0011\u001d\ty\u0004\u0001C\u0001\u0003\u0003Bq!a\u0014\u0001\t\u0003\t\t\u0006C\u0004\u0002`\u0001!\t!!\u0019\t\u000f\u0005=\u0004\u0001\"\u0001\u0002r!9\u0011q\u0010\u0001\u0005\n\u0005\u0005\u0005bBAH\u0001\u0011\u0005\u0011\u0011\u0013\u0005\b\u0003W\u0003A\u0011BAW\u0005A\u0011\u0016n]6Fm\u0016tG\u000fS1oI2,'O\u0003\u0002\u0016-\u000591/\u001a:wS\u000e,'BA\f\u0019\u0003\u0011\u0011\u0018n]6\u000b\u0005eQ\u0012!\u0003=me\u0016dW-Y:f\u0015\tYB$A\u0005yK\nL\u0017\r\\1cg*\tQ$A\u0002d_6\u001c\u0001aE\u0002\u0001A\u0019\u0002\"!\t\u0013\u000e\u0003\tR\u0011aI\u0001\u0006g\u000e\fG.Y\u0005\u0003K\t\u0012a!\u00118z%\u00164\u0007CA\u0014-\u001b\u0005A#BA\u0015+\u0003\u0015\u0019HN\u001a\u001bk\u0015\u0005Y\u0013\u0001C4sSjTH.\u001a3\n\u00055B#a\u0002'pO\u001eLgnZ\u0001\nq2\u00148i\u001c8gS\u001e\u0004\"\u0001M\u001a\u000e\u0003ER!A\r\r\u0002\r\r|gNZ5h\u0013\t!\u0014GA\u0005YYJ\u001cuN\u001c4jO\u000692m\u001c8gS\u001e,(/\u0019;j_:\u0014V\r]8tSR|'/\u001f\t\u0003oij\u0011\u0001\u000f\u0006\u0003sa\t!B]3q_NLGo\u001c:z\u0013\tY\u0004HA\fD_:4\u0017nZ;sCRLwN\u001c*fa>\u001c\u0018\u000e^8ss\u0006Y!/[:l'\u0016\u0014h/[2f!\tqt(D\u0001\u0015\u0013\t\u0001ECA\u0006SSN\\7+\u001a:wS\u000e,\u0017\u0001\b:jg.\u001c\u0015\r\\2vY\u0006$\u0018n\u001c8CCR\u001c\u0007.\u0012=fGV$xN\u001d\t\u0003\u0007*k\u0011\u0001\u0012\u0006\u0003\u000b\u001a\u000b!bY8oGV\u0014(/\u001a8u\u0015\t9\u0005*\u0001\u0003vi&d'\"A%\u0002\t)\fg/Y\u0005\u0003\u0017\u0012\u0013\u0001\"\u0012=fGV$xN]\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000b9{\u0005+\u0015*\u0011\u0005y\u0002\u0001\"\u0002\u0018\u0006\u0001\u0004y\u0003\"B\u001b\u0006\u0001\u00041\u0004\"\u0002\u001f\u0006\u0001\u0004i\u0004\"B!\u0006\u0001\u0004\u0011\u0005FA\u0003U!\t)\u0006-D\u0001W\u0015\t9\u0006,\u0001\u0006b]:|G/\u0019;j_:T!!\u0017.\u0002\u000f\u0019\f7\r^8ss*\u00111\fX\u0001\u0006E\u0016\fgn\u001d\u0006\u0003;z\u000bqb\u001d9sS:<gM]1nK^|'o\u001b\u0006\u0002?\u0006\u0019qN]4\n\u0005\u00054&!C!vi><\u0018N]3e\u00039\u0011X\r\\3bg\u0016\u001c%/Z1uK\u0012$\"\u0001Z4\u0011\u0005\u0005*\u0017B\u00014#\u0005\u0011)f.\u001b;\t\u000b!4\u0001\u0019A5\u0002'I,G.Z1tK\u000e\u0013X-\u0019;fI\u00163XM\u001c;\u0011\u0005)|W\"A6\u000b\u00051l\u0017AB3wK:$8O\u0003\u0002o1\u00051Am\\7bS:L!\u0001]6\u0003'I+G.Z1tK\u000e\u0013X-\u0019;fI\u00163XM\u001c;)\u0005\u0019\u0011\bCA:v\u001b\u0005!(B\u00017\u0019\u0013\t1HOA\u0005Tk\n\u001c8M]5cK\u0006q!/\u001a7fCN,W\u000b\u001d3bi\u0016$GC\u00013z\u0011\u0015Qx\u00011\u0001|\u0003M\u0011X\r\\3bg\u0016,\u0006\u000fZ1uK\u0012,e/\u001a8u!\tQG0\u0003\u0002~W\n\u0019\"+\u001a7fCN,W\u000b\u001d3bi\u0016$WI^3oi\"\u0012qA]\u0001\u000fe\u0016dW-Y:f\u001fZ,'\u000fZ;f)\r!\u00171\u0001\u0005\b\u0003\u000bA\u0001\u0019AA\u0004\u0003M\u0011X\r\\3bg\u0016|e/\u001a:ek\u0016,e/\u001a8u!\rQ\u0017\u0011B\u0005\u0004\u0003\u0017Y'a\u0005*fY\u0016\f7/Z(wKJ$W/Z#wK:$\bF\u0001\u0005s\u0003)!\u0018m]6GC&dW\r\u001a\u000b\u0004I\u0006M\u0001bBA\u000b\u0013\u0001\u0007\u0011qC\u0001\u0010i\u0006\u001c8NR1jY\u0016$WI^3oiB\u0019!.!\u0007\n\u0007\u0005m1NA\bUCN\\g)Y5mK\u0012,e/\u001a8uQ\tI!/A\u0007uCN\\7i\\7qY\u0016$X\r\u001a\u000b\u0004I\u0006\r\u0002bBA\u0013\u0015\u0001\u0007\u0011qE\u0001\u0013i\u0006\u001c8nQ8na2,G/\u001a3Fm\u0016tG\u000fE\u0002k\u0003SI1!a\u000bl\u0005I!\u0016m]6D_6\u0004H.\u001a;fI\u00163XM\u001c;)\u0005)\u0011\u0018a\u0003;bg.\u001c6.\u001b9qK\u0012$2\u0001ZA\u001a\u0011\u001d\t)d\u0003a\u0001\u0003o\t\u0001\u0003^1tWN[\u0017\u000e\u001d9fI\u00163XM\u001c;\u0011\u0007)\fI$C\u0002\u0002<-\u0014\u0001\u0003V1tWN[\u0017\u000e\u001d9fI\u00163XM\u001c;)\u0005-\u0011\u0018a\u0003;bg.\f%m\u001c:uK\u0012$2\u0001ZA\"\u0011\u001d\t)\u0005\u0004a\u0001\u0003\u000f\n\u0001\u0003^1tW\u0006\u0013wN\u001d;fI\u00163XM\u001c;\u0011\u0007)\fI%C\u0002\u0002L-\u0014\u0001\u0003V1tW\u0006\u0013wN\u001d;fI\u00163XM\u001c;)\u00051\u0011\u0018a\u0003;bg.,\u0006\u000fZ1uK\u0012$2\u0001ZA*\u0011\u001d\t)&\u0004a\u0001\u0003/\n\u0001\u0003^1tWV\u0003H-\u0019;fI\u00163XM\u001c;\u0011\u0007)\fI&C\u0002\u0002\\-\u0014\u0001\u0003V1tWV\u0003H-\u0019;fI\u00163XM\u001c;)\u00055\u0011\u0018a\u0003;bg.|e/\u001a:ek\u0016$2\u0001ZA2\u0011\u001d\t)G\u0004a\u0001\u0003O\n\u0001\u0003^1tW>3XM\u001d3vK\u00163XM\u001c;\u0011\u0007)\fI'C\u0002\u0002l-\u0014\u0001\u0003V1tW>3XM\u001d3vK\u00163XM\u001c;)\u00059\u0011\u0018a\u0003;bg.$U\r\\3uK\u0012$2\u0001ZA:\u0011\u001d\t)h\u0004a\u0001\u0003o\n\u0001\u0003^1tW\u0012+G.\u001a;fI\u00163XM\u001c;\u0011\u0007)\fI(C\u0002\u0002|-\u0014\u0001\u0003V1tW\u0012+G.\u001a;fI\u00163XM\u001c;)\u0005=\u0011\u0018!D2bY\u000e,H.\u0019;f%&\u001c8\u000eF\u0002e\u0003\u0007Cq!!\"\u0011\u0001\u0004\t9)A\u0004sK2,\u0017m]3\u0011\t\u0005%\u00151R\u0007\u0002[&\u0019\u0011QR7\u0003\u000fI+G.Z1tK\u00069\u0002.\u00198eY\u0016\u0014\u0016n]6Qe>4\u0017\u000e\\3Va\u0012\fG/\u001a\u000b\u0004I\u0006M\u0005bBAK#\u0001\u0007\u0011qS\u0001\u0006KZ,g\u000e\u001e\t\u0005\u00033\u000by*\u0004\u0002\u0002\u001c*\u0019A.!(\u000b\u000594\u0012\u0002BAQ\u00037\u0013!CU5tWB\u0013xNZ5mKV\u0003H-\u0019;fI\"\u001a\u0011#!*\u0011\u0007M\f9+C\u0002\u0002*R\u0014QcU=oG\"\u0014xN\\5{K\u0012\u001cVOY:de&\u0014W-A\u000fsk:\u001c\u0015\r\\2vY\u0006$\u0018n\u001c8t\r>\u0014(+[:l!J|g-\u001b7f)\r!\u0017q\u0016\u0005\b\u0003c\u0013\u0002\u0019AAZ\u0003-\u0011\u0018n]6Qe>4\u0017\u000e\\3\u0011\t\u0005U\u0016qW\u0007\u0003\u0003;KA!!/\u0002\u001e\nY!+[:l!J|g-\u001b7fQ\r\u0001\u0011Q\u0018\t\u0004g\u0006}\u0016bAAai\niQI^3oi2K7\u000f^3oKJD3\u0001AAc!\u0011\t9-!4\u000e\u0005\u0005%'bAAf9\u0006Q1\u000f^3sK>$\u0018\u0010]3\n\t\u0005=\u0017\u0011\u001a\u0002\b'\u0016\u0014h/[2f\u0001")
public class RiskEventHandler
implements Logging {
    private final XlrConfig xlrConfig;
    private final ConfigurationRepository configurationRepository;
    private final RiskService riskService;
    private final Executor riskCalculationBatchExecutor;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        RiskEventHandler riskEventHandler = this;
        synchronized (riskEventHandler) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        return !this.bitmap$trans$0 ? this.grizzled$slf4j$Logging$$_logger$lzycompute() : this.grizzled$slf4j$Logging$$_logger;
    }

    @Subscribe
    public void releaseCreated(ReleaseCreatedEvent releaseCreatedEvent) {
        this.calculateRisk(releaseCreatedEvent.release());
    }

    @Subscribe
    public void releaseUpdated(ReleaseUpdatedEvent releaseUpdatedEvent) {
        this.calculateRisk(releaseUpdatedEvent.updated());
    }

    @Subscribe
    public void releaseOverdue(ReleaseOverdueEvent releaseOverdueEvent) {
        this.calculateRisk(releaseOverdueEvent.release());
    }

    @Subscribe
    public void taskFailed(TaskFailedEvent taskFailedEvent) {
        this.calculateRisk(taskFailedEvent.task().getRelease());
    }

    @Subscribe
    public void taskCompleted(TaskCompletedEvent taskCompletedEvent) {
        this.calculateRisk(taskCompletedEvent.task().getRelease());
    }

    @Subscribe
    public void taskSkipped(TaskSkippedEvent taskSkippedEvent) {
        this.calculateRisk(taskSkippedEvent.task().getRelease());
    }

    @Subscribe
    public void taskAborted(TaskAbortedEvent taskAbortedEvent) {
        this.calculateRisk(taskAbortedEvent.task().getRelease());
    }

    @Subscribe
    public void taskUpdated(TaskUpdatedEvent taskUpdatedEvent) {
        this.calculateRisk(taskUpdatedEvent.updated().getRelease());
    }

    @Subscribe
    public void taskOverdue(TaskOverdueEvent taskOverdueEvent) {
        this.calculateRisk(taskOverdueEvent.task().getRelease());
    }

    @Subscribe
    public void taskDeleted(TaskDeletedEvent taskDeletedEvent) {
        this.calculateRisk(taskDeletedEvent.task().getRelease());
    }

    private void calculateRisk(Release release) {
        block0: {
            if (!this.xlrConfig.isRiskCalculationEnabled() || !this.riskService.isEnabled()) break block0;
            this.riskService.calculateRiskAndUpdateRelease(release);
        }
    }

    @SynchronizedSubscribe
    public void handleRiskProfileUpdate(RiskProfileUpdated event) {
        block0: {
            if (!this.xlrConfig.isRiskCalculationEnabled()) break block0;
            RiskProfile riskProfile = event.riskProfile();
            this.riskCalculationBatchExecutor.execute(() -> this.runCalculationsForRiskProfile(riskProfile));
        }
    }

    private void runCalculationsForRiskProfile(RiskProfile riskProfile) {
        this.logger().debug((Function0 & Serializable)() -> new StringBuilder(52).append("Running risk calculations after Risk profile ").append(riskProfile.getId()).append(" update").toString());
        this.configurationRepository.getReferenceReleases(riskProfile.getId()).forEach(data -> $this.riskService.calculateRiskAndUpdateRelease(data.id()));
        this.logger().debug((Function0 & Serializable)() -> new StringBuilder(61).append("Finished running risk calculations after Risk profile ").append(riskProfile.getId()).append(" update").toString());
    }

    @Autowired
    public RiskEventHandler(XlrConfig xlrConfig, ConfigurationRepository configurationRepository, RiskService riskService, Executor riskCalculationBatchExecutor) {
        this.xlrConfig = xlrConfig;
        this.configurationRepository = configurationRepository;
        this.riskService = riskService;
        this.riskCalculationBatchExecutor = riskCalculationBatchExecutor;
        Logging.$init$((Logging)this);
    }
}

