/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.api.internal;

import com.google.common.base.Charsets;
import com.xebialabs.deployit.core.api.InternalSecurityProxy;
import com.xebialabs.deployit.core.api.dto.RolePermissions;
import com.xebialabs.deployit.core.rest.resteasy.WorkDirTemplate;
import com.xebialabs.deployit.core.rest.resteasy.Workdir;
import com.xebialabs.deployit.engine.api.security.RolePrincipals;
import com.xebialabs.deployit.engine.api.security.User;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.base.BaseConfigurationItem;
import com.xebialabs.deployit.repository.WorkDir;
import com.xebialabs.deployit.repository.WorkDirFactory;
import com.xebialabs.deployit.security.RoleService;
import com.xebialabs.deployit.security.UserService;
import com.xebialabs.deployit.security.permission.PlatformPermissions;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.overthere.local.LocalFile;
import com.xebialabs.xlrelease.actors.utils.ReleaseActorLifecycleUtils;
import com.xebialabs.xlrelease.api.internal.CalendarResource;
import com.xebialabs.xlrelease.api.v1.forms.ReleasesFilters;
import com.xebialabs.xlrelease.configuration.TaskAccess;
import com.xebialabs.xlrelease.db.ArchivedReleases;
import com.xebialabs.xlrelease.domain.ActivityLogEntry;
import com.xebialabs.xlrelease.domain.Attachment;
import com.xebialabs.xlrelease.domain.BaseConfiguration;
import com.xebialabs.xlrelease.domain.Comment;
import com.xebialabs.xlrelease.domain.Configuration;
import com.xebialabs.xlrelease.domain.PlanItem;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.Team;
import com.xebialabs.xlrelease.domain.Trigger;
import com.xebialabs.xlrelease.domain.VisitableItem;
import com.xebialabs.xlrelease.domain.calendar.Blackout;
import com.xebialabs.xlrelease.domain.calendar.CalendarEntry;
import com.xebialabs.xlrelease.domain.calendar.SpecialDay;
import com.xebialabs.xlrelease.domain.events.CreatedWithoutTemplate;
import com.xebialabs.xlrelease.domain.events.Imported;
import com.xebialabs.xlrelease.domain.events.ReleaseCreatedEvent;
import com.xebialabs.xlrelease.domain.events.ReleaseCreationSource;
import com.xebialabs.xlrelease.domain.events.ReleaseDeletedEvent;
import com.xebialabs.xlrelease.domain.events.XLReleaseEvent;
import com.xebialabs.xlrelease.domain.facet.Facet;
import com.xebialabs.xlrelease.domain.folder.Folder;
import com.xebialabs.xlrelease.domain.variables.Variable;
import com.xebialabs.xlrelease.events.XLReleaseEventBus;
import com.xebialabs.xlrelease.repository.ActivityLogRepository;
import com.xebialabs.xlrelease.repository.CalendarEntryRepository;
import com.xebialabs.xlrelease.repository.ConfigurationRepository;
import com.xebialabs.xlrelease.repository.FolderRepository;
import com.xebialabs.xlrelease.repository.FolderVariableRepository;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.ReleaseRepository;
import com.xebialabs.xlrelease.repository.TaskRepository;
import com.xebialabs.xlrelease.repository.TriggerRepository;
import com.xebialabs.xlrelease.search.ReleaseSearchResult;
import com.xebialabs.xlrelease.security.PermissionChecker;
import com.xebialabs.xlrelease.security.SessionService;
import com.xebialabs.xlrelease.serialization.json.repository.ResolveOptionsBuilder;
import com.xebialabs.xlrelease.service.ArchivingScheduleService;
import com.xebialabs.xlrelease.service.ArchivingService;
import com.xebialabs.xlrelease.service.CiIdService;
import com.xebialabs.xlrelease.service.ConfigurationService;
import com.xebialabs.xlrelease.service.FacetService;
import com.xebialabs.xlrelease.service.ReleaseSearchService;
import com.xebialabs.xlrelease.service.TeamService;
import com.xebialabs.xlrelease.service.UserProfileService;
import com.xebialabs.xlrelease.service.UserTokenService;
import com.xebialabs.xlrelease.service.VariableService;
import com.xebialabs.xlrelease.triggers.service.TriggerService;
import com.xebialabs.xlrelease.triggers.service.impl.TriggerLifecycle;
import com.xebialabs.xlrelease.utils.CiHelper;
import com.xebialabs.xlrelease.variable.VariablePersistenceHelper;
import com.xebialabs.xlrelease.views.FixturesUser;
import com.xebialabs.xlrelease.views.RolePermissionsView;
import com.xebialabs.xlrelease.views.RolePrincipalsView;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.retry.support.RetryTemplate;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.util.FileCopyUtils;
import scala.concurrent.duration.FiniteDuration;
import scala.util.Random;

@javax.ws.rs.Path(value="/fixtures")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Controller
@NoCache
public class FixturesResource {
    private static final Logger logger = LoggerFactory.getLogger(FixturesResource.class);
    private final RetryTemplate retryTemplate;
    private final RetryTemplate releaseSearchRetryTemplate;
    private PermissionChecker permissions;
    private InternalSecurityProxy internalSecurityProxy;
    private UserService userService;
    private UserProfileService userProfileService;
    private SessionService sessionService;
    private ArchivingService archivingService;
    private ArchivingScheduleService archivingScheduleService;
    private WorkDirFactory workDirFactory;
    private VariableService variableService;
    private ReleaseActorLifecycleUtils releaseActorLifecycleUtils;
    private TeamService teamService;
    private ConfigurationService configurationService;
    private XLReleaseEventBus eventBus;
    private RoleService roleService;
    private ActivityLogRepository activityLogRepository;
    private FolderRepository folderRepository;
    private FolderVariableRepository folderVariableRepository;
    private ReleaseRepository releaseRepository;
    private CiIdService ciIdService;
    private TaskRepository taskRepository;
    private ConfigurationRepository configurationRepository;
    private CalendarEntryRepository calendarEntryRepository;
    private CalendarResource calendarResource;
    private FacetService facetService;
    private JdbcTemplate reportingJdbcTemplate;
    private TriggerRepository triggerRepository;
    private TriggerLifecycle<Trigger> triggerLifecycle;
    private TriggerService triggerService;
    private UserTokenService userTokenService;
    private ReleaseSearchService releaseSearchService;

    @Autowired
    public FixturesResource(PermissionChecker permissions, InternalSecurityProxy internalSecurityProxy, UserService userService, UserProfileService userProfileService, SessionService sessionService, ArchivingService archivingService, ArchivingScheduleService archivingScheduleService, WorkDirFactory workDirFactory, VariableService variableService, ReleaseActorLifecycleUtils releaseActorLifecycleUtils, TeamService teamService, ConfigurationService configurationService, XLReleaseEventBus eventBus, RoleService roleService, ActivityLogRepository activityLogRepository, FolderRepository folderRepository, FolderVariableRepository folderVariableRepository, ReleaseRepository releaseRepository, CiIdService ciIdService, TaskRepository taskRepository, ConfigurationRepository configurationRepository, CalendarEntryRepository calendarEntryRepository, CalendarResource calendarResource, FacetService facetService, @Qualifier(value="reportingJdbcTemplate") JdbcTemplate reportingJdbcTemplate, TriggerRepository triggerRepository, TriggerLifecycle<Trigger> triggerLifecycle, TriggerService triggerService, UserTokenService userTokenService, ReleaseSearchService releaseSearchService, @Value(value="5") Integer retryAttempts) {
        this.permissions = permissions;
        this.internalSecurityProxy = internalSecurityProxy;
        this.userService = userService;
        this.userProfileService = userProfileService;
        this.sessionService = sessionService;
        this.archivingService = archivingService;
        this.archivingScheduleService = archivingScheduleService;
        this.workDirFactory = workDirFactory;
        this.variableService = variableService;
        this.releaseActorLifecycleUtils = releaseActorLifecycleUtils;
        this.teamService = teamService;
        this.configurationService = configurationService;
        this.eventBus = eventBus;
        this.roleService = roleService;
        this.activityLogRepository = activityLogRepository;
        this.folderRepository = folderRepository;
        this.folderVariableRepository = folderVariableRepository;
        this.releaseRepository = releaseRepository;
        this.ciIdService = ciIdService;
        this.taskRepository = taskRepository;
        this.configurationRepository = configurationRepository;
        this.calendarEntryRepository = calendarEntryRepository;
        this.calendarResource = calendarResource;
        this.facetService = facetService;
        this.reportingJdbcTemplate = reportingJdbcTemplate;
        this.triggerRepository = triggerRepository;
        this.triggerLifecycle = triggerLifecycle;
        this.triggerService = triggerService;
        this.userTokenService = userTokenService;
        this.releaseSearchService = releaseSearchService;
        this.retryTemplate = RetryTemplate.builder().maxAttempts(retryAttempts.intValue()).exponentialBackoff(300L, 2.0, 5000L).retryOn(RuntimeException.class).build();
        this.releaseSearchRetryTemplate = RetryTemplate.builder().maxAttempts(2).fixedBackoff(1000L).build();
    }

    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @POST
    @Deprecated
    public void createEntities(List<ConfigurationItem> entities) {
        this.permissions.check(PlatformPermissions.ADMIN);
        logger.debug(String.format("Creating entities: %s", entities));
        List<String> releaseIds = entities.stream().filter(ci -> ci.getType().equals((Object)Type.valueOf(Release.class))).map(ConfigurationItem::getId).collect(Collectors.toList());
        this.createOrUpdateCis(entities);
        releaseIds.forEach(id -> {
            Release release = this.releaseRepository.findById(id);
            this.eventBus.publish((XLReleaseEvent)new ReleaseCreatedEvent(release, (ReleaseCreationSource)new Imported()));
        });
    }

    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @POST
    @javax.ws.rs.Path(value="tree")
    @Deprecated
    public void createCiTree(ConfigurationItem ci) {
        this.permissions.check(PlatformPermissions.ADMIN);
        logger.debug(String.format("Creating entity: %s", ci));
        this.createOrUpdateCis(CiHelper.getNestedCis((ConfigurationItem)ci));
    }

    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @POST
    @javax.ws.rs.Path(value="releases")
    public void createReleases(List<Release> releases) {
        releases.forEach(this::createRelease);
    }

    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @POST
    @javax.ws.rs.Path(value="release")
    public void createRelease(Release release) {
        this.permissions.check(PlatformPermissions.ADMIN);
        logger.debug(String.format("Creating release: %s", release));
        this.assignDefaultRiskProfileIfMissing(release);
        WorkDir workDir = this.workDirFactory.newWorkDir("external");
        WorkDirTemplate.cleanOnFinally((WorkDir)workDir, wd -> {
            List attachments = release.getAttachments();
            try {
                this.enrichAttachments(attachments, wd);
                VariablePersistenceHelper.scanAndBuildNewVariables((Release)release, (VisitableItem)release, (CiIdService)this.ciIdService);
                this.releaseRepository.create(release, (ReleaseCreationSource)new CreatedWithoutTemplate());
                this.eventBus.publish((XLReleaseEvent)new ReleaseCreatedEvent(release, null));
                Object var4_4 = null;
                return var4_4;
            }
            finally {
                attachments.forEach(a -> a.getFile().delete());
            }
        });
        release.getTeams().forEach(team -> team.setId(null));
        this.teamService.saveTeamsToPlatform(release);
    }

    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @POST
    @javax.ws.rs.Path(value="activityLogs/{releaseId:.*}")
    public void createActivityLogs(@PathParam(value="releaseId") String releaseId, List<ActivityLogEntry> logs) {
        this.permissions.check(PlatformPermissions.ADMIN);
        logger.debug(String.format("Creating activity logs: %s", logs));
        logs.forEach(log -> {
            if (log.hasUsername()) {
                this.activityLogRepository.log(releaseId, log, log.getUsername());
            } else {
                this.activityLogRepository.log(releaseId, log);
            }
        });
    }

    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @POST
    @javax.ws.rs.Path(value="preArchived")
    public void createPreArchivedRelease(Release release) {
        this.permissions.check(PlatformPermissions.ADMIN);
        this.createRelease(release);
        logger.debug(String.format("Pre-archiving release: %s", release));
        this.archivingService.preArchiveRelease(release);
    }

    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @POST
    @javax.ws.rs.Path(value="archived")
    public void createArchivedRelease(Release release) {
        this.createPreArchivedRelease(release);
        logger.debug(String.format("Archiving release: %s", release));
        this.archiveRelease(release.getId());
    }

    @GET
    @javax.ws.rs.Path(value="preArchive/{releaseId:.*}")
    public Response preArchiveRelease(@PathParam(value="releaseId") String releaseId) {
        this.permissions.check(PlatformPermissions.ADMIN);
        Release release = this.releaseRepository.findById(releaseId);
        this.archivingService.preArchiveRelease(release);
        return Response.status((Response.Status)Response.Status.ACCEPTED).build();
    }

    @javax.ws.rs.Path(value="archive/{releaseId:.*}")
    @GET
    public Response archiveRelease(@PathParam(value="releaseId") String releaseId) {
        this.permissions.check(PlatformPermissions.ADMIN);
        this.releaseActorLifecycleUtils.terminateReleaseActorAndAwait(releaseId, FiniteDuration.apply((long)5L, (TimeUnit)TimeUnit.SECONDS));
        this.archivingService.archiveRelease(releaseId);
        return Response.status((Response.Status)Response.Status.ACCEPTED).build();
    }

    @POST
    @javax.ws.rs.Path(value="archiveAll")
    public Response triggerArchivingOfCompletedReleases() {
        this.permissions.check(PlatformPermissions.ADMIN);
        logger.debug("Archiving all finished releases");
        this.archivingScheduleService.processExpiredReleases(Integer.valueOf(0));
        return Response.ok().build();
    }

    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @PUT
    public void updateEntities(List<ConfigurationItem> entities) {
        this.permissions.check(PlatformPermissions.ADMIN);
        logger.debug(String.format("Updating entities: %s", entities));
        List releaseCis = entities.stream().filter(ci -> ci instanceof PlanItem).collect(Collectors.toList());
        if (!releaseCis.isEmpty()) {
            throw new UnsupportedOperationException("You cannot update parts of release using PUT /fixtures: " + releaseCis);
        }
        this.createOrUpdateCis(entities);
    }

    @javax.ws.rs.Path(value="task-access")
    @DELETE
    public void deleteTaskAccess() {
        this.permissions.check(PlatformPermissions.ADMIN);
        logger.debug("Deleting all task accesses");
        this.deleteAll(TaskAccess.class);
    }

    @javax.ws.rs.Path(value="{id:(Applications|Folder|Template|Release|Custom|Configuration).*}")
    @DELETE
    public void deleteApplicationEntity(@PathParam(value="id") String id) {
        this.permissions.check(PlatformPermissions.ADMIN);
        logger.debug(String.format("Deleting application entity: [%s]", id));
        this.deleteCi(id);
    }

    @javax.ws.rs.Path(value="/configurations")
    @POST
    public void createConfigurationItems(List<BaseConfiguration> baseConfigurations) {
        this.permissions.check(PlatformPermissions.ADMIN);
        logger.debug("Creating configuration entities");
        this.createOrUpdateConfiguration(baseConfigurations);
    }

    @javax.ws.rs.Path(value="/configuration/{id:.*}")
    @DELETE
    public void deleteConfigurationItem(@PathParam(value="id") String id) {
        this.permissions.check(PlatformPermissions.ADMIN);
        logger.debug(String.format("Deleting configuration entity: [%s]", id));
        this.deleteCi("Configuration/" + id);
    }

    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @javax.ws.rs.Path(value="/user")
    @POST
    public void createUser(FixturesUser fixturesUser) {
        this.permissions.check(PlatformPermissions.ADMIN);
        logger.debug(String.format("Creating user: %s", fixturesUser.getUsername()));
        User user = fixturesUser.toUser();
        try {
            this.userService.read(user.getUsername());
            logger.debug(String.format("User %s already exists", user.getUsername()));
        }
        catch (NotFoundException e) {
            this.userService.create(user.getUsername(), user.getPassword());
        }
    }

    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @javax.ws.rs.Path(value="/folders")
    @POST
    public void createFolders(List<Folder> folders) {
        this.permissions.check(PlatformPermissions.ADMIN);
        folders.stream().sorted(Comparator.comparing(BaseConfigurationItem::getId)).filter(folder -> !this.folderRepository.exists(folder.getId())).forEach(folder -> this.folderRepository.create(Ids.getParentId((String)folder.getId()), folder));
    }

    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @javax.ws.rs.Path(value="/folders/variables")
    @POST
    public List<Variable> createFolderVariables(List<Variable> variables) {
        this.permissions.check(PlatformPermissions.ADMIN);
        return variables.stream().filter(variable -> !this.folderVariableRepository.exists(variable.getId())).map(variable -> this.folderVariableRepository.create(variable)).collect(Collectors.toList());
    }

    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @javax.ws.rs.Path(value="/folders/variable/{variableId}")
    @DELETE
    public void deleteFolderVariable(@PathParam(value="variableId") String variableId) {
        this.permissions.check(PlatformPermissions.ADMIN);
        if (this.folderVariableRepository.exists(variableId)) {
            this.folderVariableRepository.delete(variableId);
        }
    }

    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @javax.ws.rs.Path(value="/teams")
    @POST
    public void createTeams(List<Team> teams) {
        this.permissions.check(PlatformPermissions.ADMIN);
        teams.stream().collect(Collectors.groupingBy(team -> Ids.getParentId((String)team.getId()))).forEach((containerId, teamsList) -> this.teamService.saveTeamsToPlatform(containerId, teamsList));
    }

    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @javax.ws.rs.Path(value="/shared")
    @POST
    public void createSharedConfigurations(List<Configuration> configurations) {
        this.permissions.check(PlatformPermissions.ADMIN);
        configurations.forEach(configuration -> this.configurationRepository.create((BaseConfiguration)configuration));
    }

    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @javax.ws.rs.Path(value="/shared")
    @DELETE
    public void deleteSharedConfigurations(List<String> configurationIds) {
        this.permissions.check(PlatformPermissions.ADMIN);
        configurationIds.forEach(configurationId -> this.configurationRepository.delete(configurationId));
    }

    @javax.ws.rs.Path(value="/user/{login}")
    @DELETE
    public void deleteUser(@PathParam(value="login") String login) {
        this.permissions.check(PlatformPermissions.ADMIN);
        logger.debug(String.format("Deleting user: %s", login));
        this.userService.delete(login);
        this.userProfileService.deleteByUsername(login);
        this.sessionService.disconnect(login);
    }

    @javax.ws.rs.Path(value="/role/{roleName}")
    @DELETE
    public void deleteRole(@PathParam(value="roleName") String roleName) {
        this.permissions.check(PlatformPermissions.ADMIN);
        logger.debug(String.format("Deleting role: %s", roleName));
        try {
            this.roleService.deleteByName(roleName);
        }
        catch (NotFoundException e) {
            logger.warn(e.getMessage(), (Throwable)e);
        }
    }

    @javax.ws.rs.Path(value="/calendar")
    @DELETE
    public void deleteCalendar() {
        this.permissions.check(PlatformPermissions.ADMIN);
        logger.debug("Deleting all special days and blackouts from calendar");
        Stream.concat(this.calendarEntryRepository.findAllByType(Type.valueOf(Blackout.class)).stream(), this.calendarEntryRepository.findAllByType(Type.valueOf(SpecialDay.class)).stream()).forEach(entry -> this.calendarEntryRepository.delete(entry.getId()));
    }

    @javax.ws.rs.Path(value="/cis")
    @DELETE
    public void deleteCIs(List<ConfigurationItem> cis) {
        this.permissions.check(PlatformPermissions.ADMIN);
        logger.debug(String.format("Deleting CIs: %s", cis));
        for (ConfigurationItem ci : cis) {
            this.deleteCi(ci.getId());
        }
    }

    @javax.ws.rs.Path(value="/expectContainingAttachments/{releaseId:.*}")
    @POST
    @Workdir(prefix="artifact")
    public Response expectContainingAttachments(@PathParam(value="releaseId") String releaseId, ExpectedAttachment expectedAttachment) throws IOException {
        this.permissions.check(PlatformPermissions.ADMIN);
        Release release = this.releaseRepository.findById(releaseId);
        for (Attachment attachment : release.getAttachments()) {
            OverthereFile file = attachment.getFile();
            if (!file.getName().equals(expectedAttachment.getName())) continue;
            return this.checkContent(expectedAttachment, file);
        }
        throw new Error("Attachment not found");
    }

    private Response checkContent(ExpectedAttachment expectedAttachment, OverthereFile file) throws IOException {
        try (InputStream inputStream = file.getInputStream();){
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            FileCopyUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
            String content = outputStream.toString(Charsets.UTF_8.name());
            if (content.equals(expectedAttachment.getExpectedContent())) {
                Response response = Response.ok().build();
                return response;
            }
            throw new Error("Expected content to be " + expectedAttachment.getExpectedContent() + " content found : " + content);
        }
    }

    @POST
    @javax.ws.rs.Path(value="roles/permissions/{id:.*?}")
    public void writeRolePermissions(@PathParam(value="id") String id, List<RolePermissionsView> rolePermissionsViews) {
        this.permissions.check(PlatformPermissions.ADMIN);
        logger.debug(String.format("Setting %d role permissions for [%s]", rolePermissionsViews.size(), id));
        List<RolePermissions> permissions = rolePermissionsViews.stream().map(RolePermissionsView::toRolePermissions).collect(Collectors.toList());
        permissions.forEach(p -> this.teamService.generateIdIfNecessary(p.getRole()));
        this.internalSecurityProxy.writeRolePermissions(id, permissions);
    }

    @POST
    @javax.ws.rs.Path(value="roles/principals")
    public void writeRolePrincipals(List<RolePrincipalsView> rolePrincipalsViews) {
        this.permissions.check(PlatformPermissions.ADMIN);
        logger.debug(String.format("Setting %d role principals", rolePrincipalsViews.size()));
        List<RolePrincipals> rolePrincipals = rolePrincipalsViews.stream().map(RolePrincipalsView::toRolePrincipals).collect(Collectors.toList());
        rolePrincipals.forEach(rp -> this.teamService.generateIdIfNecessary(rp.getRole()));
        this.internalSecurityProxy.writeRolePrincipals(rolePrincipals);
    }

    @POST
    @javax.ws.rs.Path(value="expectCommentAdded/{taskId:.*?}")
    public boolean checkCommentAdded(@PathParam(value="taskId") String taskId, String textToSearch) {
        Task task = this.taskRepository.findById(taskId, new ResolveOptionsBuilder().build());
        for (Comment comment : task.getComments()) {
            if (!comment.getText().contains(textToSearch)) continue;
            return true;
        }
        return false;
    }

    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @POST
    @javax.ws.rs.Path(value="facet")
    public Facet createFacet(Facet facet) {
        this.permissions.check(PlatformPermissions.ADMIN);
        return this.facetService.create(facet);
    }

    @GET
    @javax.ws.rs.Path(value="auth")
    public boolean checkAuthentication() {
        return SecurityContextHolder.getContext().getAuthentication().isAuthenticated();
    }

    private void deleteAll(Class<? extends ConfigurationItem> ciClass) {
        this.permissions.check(PlatformPermissions.ADMIN);
        Type ciType = Type.valueOf(ciClass);
        if (!ciType.isSubTypeOf(Type.valueOf(BaseConfiguration.class))) {
            throw new IllegalArgumentException(String.format("Unable to delete CIs of type: '%s'", ciType));
        }
        this.configurationRepository.findAllByType(ciType).forEach(ci -> this.configurationRepository.delete(ci.getId()));
    }

    @javax.ws.rs.Path(value="/globalVariables/")
    @DELETE
    public void deleteGlobalVariables() {
        this.permissions.check(PlatformPermissions.ADMIN);
        logger.debug("Deleting all global variables");
        this.variableService.findGlobalVariablesOrEmpty().getVariables().forEach(v -> this.variableService.deleteGlobalVariable(v.getId()));
    }

    @javax.ws.rs.Path(value="/trigger")
    @POST
    public void createTrigger(Trigger trigger) {
        Trigger addedTrigger = this.triggerRepository.create(trigger);
        this.triggerLifecycle.enable(addedTrigger, true);
    }

    @javax.ws.rs.Path(value="/trigger/{triggerId:.*}")
    @DELETE
    public void deleteTrigger(@PathParam(value="triggerId") String triggerId) {
        this.triggerService.disableTriggers(List.of(triggerId));
        ReleasesFilters filter = new ReleasesFilters();
        String triggerTag = Ids.getName((String)triggerId);
        filter.setTags(List.of(triggerTag));
        try {
            this.releaseSearchRetryTemplate.execute(ctx -> {
                ReleaseSearchResult result = this.releaseSearchService.search(filter, 0L, Integer.MAX_VALUE);
                logger.info(String.format("Found %d releases from trigger %s", result.getReleases().size(), triggerTag));
                result.getReleases().forEach(r -> this.deleteCi(r.getId()));
                if (result.getReleases().isEmpty()) {
                    throw new RuntimeException("No releases found. Try once more to confirm all are deleted!");
                }
                return null;
            });
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        this.triggerService.deleteTrigger(triggerId);
    }

    @javax.ws.rs.Path(value="/tokens/{username}")
    @DELETE
    public void deleteUserTokens(@PathParam(value="username") String username) {
        this.permissions.check(PlatformPermissions.ADMIN);
        logger.debug(String.format("Deleting all personal access token for user[%s]", username));
        this.userTokenService.deleteAllUserToken(username);
    }

    private void assignDefaultRiskProfileIfMissing(Release release) {
        if (release.hasProperty("riskProfile") && release.getProperty("riskProfile") == null) {
            release.setProperty("riskProfile", (Object)this.configurationRepository.read("Configuration/riskProfiles/RiskProfileDefault"));
        }
    }

    private void createOrUpdateCis(List<ConfigurationItem> entities) {
        this.createOrUpdateCalendar(this.takeAllByType(entities, CalendarEntry.class));
        this.createOrUpdateConfiguration(this.takeAllByType(entities, BaseConfiguration.class).stream().map(BaseConfiguration.class::cast).collect(Collectors.toList()));
        this.createOrUpdateTeams(this.takeAllByType(entities, Team.class));
        this.createOrUpdateOther(entities);
    }

    private void createOrUpdateCalendar(List<ConfigurationItem> cis) {
        cis.forEach(ci -> {
            if (ci instanceof SpecialDay) {
                this.calendarResource.setSpecialDay(ci.getId(), (SpecialDay)ci);
            } else {
                this.calendarEntryRepository.createOrUpdate((CalendarEntry)ci);
            }
        });
    }

    private void createOrUpdateConfiguration(List<BaseConfiguration> cis) {
        cis.forEach(arg_0 -> ((ConfigurationService)this.configurationService).createOrUpdate(arg_0));
    }

    private void createOrUpdateOther(List<ConfigurationItem> cis) {
        if (!cis.isEmpty()) {
            String ciList = cis.stream().map(ci -> ci.getId() + ci.getType()).collect(Collectors.joining(","));
            throw new IllegalArgumentException(String.format("Unable to delete entities '%s'", ciList));
        }
    }

    private List<ConfigurationItem> takeAllByType(List<ConfigurationItem> cis, Class<? extends ConfigurationItem> ciClass) {
        List<ConfigurationItem> items = cis.stream().filter(ci -> ci.getType().instanceOf(Type.valueOf((Class)ciClass))).collect(Collectors.toList());
        cis.removeAll(items);
        return items;
    }

    private void enrichAttachments(List<Attachment> attachments, WorkDir workDir) {
        for (Attachment attachment : attachments) {
            logger.debug("Enriching attachment " + attachment.getId());
            LocalFile dummyFile = workDir.newFile(attachment.getName() + ".txt");
            Random random = new Random();
            List<String> lines = this.findSizeSpecInAttachmentName(attachment.getName()).map(sizeInKb -> IntStream.range(0, sizeInKb).mapToObj(i -> random.nextString(341)).collect(Collectors.toList())).orElse(Collections.singletonList("test"));
            Path dummyFilePath = Paths.get(dummyFile.getFile().toURI());
            try {
                Files.write(dummyFilePath, lines, StandardOpenOption.CREATE_NEW, StandardOpenOption.WRITE);
                attachment.setFile((OverthereFile)dummyFile);
            }
            catch (IOException e) {
                throw new RuntimeException("Could not create dummy content for attachment " + attachment.getId(), e);
            }
        }
    }

    private void createOrUpdateTeams(Collection<ConfigurationItem> entities) {
        HashMap<String, List> containersToTeams = new HashMap<String, List>();
        entities.forEach(team -> {
            String containerId = Ids.getParentId((String)team.getId());
            team.setId(null);
            containersToTeams.computeIfAbsent(containerId, s -> new ArrayList()).add((Team)team);
        });
        containersToTeams.forEach((arg_0, arg_1) -> ((TeamService)this.teamService).saveTeamsToPlatform(arg_0, arg_1));
    }

    private void deleteCi(String id) {
        if (Ids.isReleaseId((String)id)) {
            try {
                this.releaseActorLifecycleUtils.terminateReleaseActorAndAwait(id, FiniteDuration.apply((long)5L, (TimeUnit)TimeUnit.SECONDS));
            }
            catch (Exception e) {
                logger.error(String.format("Could not terminate release actor %s within timeout", id), (Throwable)e);
            }
            this.deleteFromArchive(id);
            if (this.releaseRepository.exists(id)) {
                this.deleteReleaseWithRetry(id);
                Release deletedRelease = (Release)Type.valueOf(Release.class).getDescriptor().newInstance(id);
                this.eventBus.publish((XLReleaseEvent)new ReleaseDeletedEvent(deletedRelease));
            }
        } else if (Ids.isCalendarId((String)id)) {
            if (this.calendarEntryRepository.exists(id)) {
                this.calendarEntryRepository.delete(id);
            }
        } else if (Ids.isConfigurationId((String)id)) {
            if (this.configurationRepository.exists(id)) {
                this.configurationRepository.delete(id);
            }
        } else {
            throw new IllegalArgumentException(String.format("Unable to delete CI with id: %s", id));
        }
    }

    private void deleteReleaseWithRetry(String releaseId) {
        this.retryTemplate.execute(ctx -> {
            logger.trace("Attempted to delete {} for {} time", (Object)releaseId, (Object)ctx.getRetryCount());
            this.releaseRepository.delete(releaseId, true);
            return null;
        });
    }

    private Optional<Integer> findSizeSpecInAttachmentName(String name) {
        Pattern pattern = Pattern.compile(".*_(\\d+)KB.*");
        Matcher matcher = pattern.matcher(name);
        if (matcher.find()) {
            return Optional.of(Integer.parseInt(matcher.group(1)));
        }
        return Optional.empty();
    }

    private int deleteFromArchive(String id) {
        return this.reportingJdbcTemplate.update(String.format("DELETE FROM %s WHERE %s IN (?, ?)", ArchivedReleases.REPORT_RELEASES_TABLE_NAME(), ArchivedReleases.REPORT_RELEASES_ID_COLUMN()), new Object[]{ArchivedReleases.shortenId((String)id), "Applications/" + ArchivedReleases.shortenId((String)id)});
    }

    private static class ExpectedAttachment {
        String name;
        String expectedContent;

        public String getName() {
            return this.name;
        }

        public String getExpectedContent() {
            return this.expectedContent;
        }
    }
}

