/*
 * Decompiled with CFR 0.152.
 */
package com.ryantenney.metrics.spring;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.codahale.metrics.annotation.Timed;
import com.ryantenney.metrics.spring.AbstractMetricMethodInterceptor;
import com.ryantenney.metrics.spring.AdviceFactory;
import com.ryantenney.metrics.spring.AnnotationFilter;
import com.ryantenney.metrics.spring.Util;
import java.lang.reflect.Method;
import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.aop.Pointcut;
import org.springframework.aop.support.annotation.AnnotationMatchingPointcut;
import org.springframework.core.Ordered;
import org.springframework.util.ReflectionUtils;

class TimedMethodInterceptor
extends AbstractMetricMethodInterceptor<Timed, Timer>
implements Ordered {
    public static final Class<Timed> ANNOTATION = Timed.class;
    public static final Pointcut POINTCUT = new AnnotationMatchingPointcut(null, ANNOTATION);
    public static final ReflectionUtils.MethodFilter METHOD_FILTER = new AnnotationFilter(ANNOTATION, 2469);

    public TimedMethodInterceptor(MetricRegistry metricRegistry, Class<?> targetClass) {
        super(metricRegistry, targetClass, ANNOTATION, METHOD_FILTER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Object invoke(MethodInvocation invocation, Timer timer, Timed annotation) throws Throwable {
        Timer.Context timerCtx = timer.time();
        try {
            Object object = invocation.proceed();
            return object;
        }
        finally {
            timerCtx.close();
        }
    }

    @Override
    protected Timer buildMetric(MetricRegistry metricRegistry, String metricName, Timed annotation) {
        return metricRegistry.timer(metricName);
    }

    @Override
    protected String buildMetricName(Class<?> targetClass, Method method, Timed annotation) {
        return Util.forTimedMethod(targetClass, method, annotation);
    }

    public int getOrder() {
        return Integer.MIN_VALUE;
    }

    static AdviceFactory adviceFactory(final MetricRegistry metricRegistry) {
        return new AdviceFactory(){

            @Override
            public Advice getAdvice(Object bean, Class<?> targetClass) {
                return new TimedMethodInterceptor(metricRegistry, targetClass);
            }
        };
    }
}

