/*
 * Decompiled with CFR 0.152.
 */
package liquibase.repackaged.org.apache.commons.text.lookup;

import java.util.Date;
import liquibase.repackaged.org.apache.commons.lang3.time.FastDateFormat;
import liquibase.repackaged.org.apache.commons.text.lookup.AbstractStringLookup;
import liquibase.repackaged.org.apache.commons.text.lookup.IllegalArgumentExceptions;

final class DateStringLookup
extends AbstractStringLookup {
    static final DateStringLookup INSTANCE = new DateStringLookup();

    private DateStringLookup() {
    }

    private String formatDate(long date, String format) {
        FastDateFormat dateFormat = null;
        if (format != null) {
            try {
                dateFormat = FastDateFormat.getInstance(format);
            }
            catch (Exception ex2) {
                throw IllegalArgumentExceptions.format(ex2, "Invalid date format: [%s]", format);
            }
        }
        if (dateFormat == null) {
            dateFormat = FastDateFormat.getInstance();
        }
        return dateFormat.format(new Date(date));
    }

    @Override
    public String lookup(String key) {
        return this.formatDate(System.currentTimeMillis(), key);
    }
}

