/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.plugin.blackduck;

import com.synopsys.integration.blackduck.configuration.BlackDuckServerConfig;
import com.synopsys.integration.blackduck.configuration.BlackDuckServerConfigBuilder;
import com.synopsys.integration.blackduck.http.client.BlackDuckHttpClient;
import com.synopsys.integration.blackduck.service.BlackDuckServicesFactory;
import com.synopsys.integration.log.IntLogger;
import com.synopsys.integration.log.LogLevel;
import com.synopsys.integration.log.PrintStreamIntLogger;
import com.synopsys.integration.util.IntEnvironmentVariables;
import com.xebialabs.xlrelease.plugin.blackduck.BlackDuckCompositeService;

public class RestConnectionHelper {
    private String blackduckServerUrl;
    private String username;
    private String password;
    private String apiToken;
    private boolean trustCertificate;
    private String proxyHost;
    private String proxyPort;
    private String proxyUsername;
    private String proxyPassword;

    public RestConnectionHelper(String blackduckServerUrl, String username, String password, String apiToken, String proxyHost, String proxyPort, String proxyUsername, String proxyPassword, Boolean trustCertificate) {
        this.blackduckServerUrl = blackduckServerUrl;
        this.username = username;
        this.password = password;
        this.apiToken = apiToken;
        this.proxyHost = proxyHost;
        this.proxyPort = proxyPort;
        this.proxyUsername = proxyUsername;
        this.proxyPassword = proxyPassword;
        this.trustCertificate = trustCertificate;
    }

    public BlackDuckServerConfig getBlackDuckServerConfig() {
        BlackDuckServerConfigBuilder builder = new BlackDuckServerConfigBuilder();
        builder.setUrl(this.blackduckServerUrl);
        builder.setUsername(this.username);
        builder.setPassword(this.password);
        builder.setApiToken(this.apiToken);
        builder.setProxyHost(this.proxyHost);
        builder.setProxyPort(this.proxyPort);
        builder.setProxyUsername(this.proxyUsername);
        builder.setProxyPassword(this.proxyPassword);
        builder.setTrustCert(this.trustCertificate);
        return (BlackDuckServerConfig)builder.build();
    }

    public BlackDuckHttpClient getIntegrationHubRestConnection() {
        return this.getRestConnection(this.getBlackDuckServerConfig());
    }

    public BlackDuckHttpClient getRestConnection(BlackDuckServerConfig serverConfig) {
        return this.getRestConnection(serverConfig, LogLevel.INFO);
    }

    public BlackDuckHttpClient getRestConnection(BlackDuckServerConfig serverConfig, LogLevel logLevel) {
        return serverConfig.createBlackDuckHttpClient(new PrintStreamIntLogger(System.out, logLevel));
    }

    public BlackDuckServicesFactory createBlackDuckServicesFactory() {
        return this.createBlackDuckServicesFactory(LogLevel.INFO);
    }

    public BlackDuckServicesFactory createBlackDuckServicesFactory(LogLevel logLevel) {
        return this.createBlackDuckServicesFactory(this.createIntLogger(logLevel));
    }

    public IntLogger createIntLogger(LogLevel logLevel) {
        return new PrintStreamIntLogger(System.out, logLevel);
    }

    public BlackDuckServicesFactory createBlackDuckServicesFactory(IntLogger logger) {
        BlackDuckHttpClient restConnection = this.getIntegrationHubRestConnection();
        return new BlackDuckServicesFactory(IntEnvironmentVariables.empty(), BlackDuckServicesFactory.createDefaultGson(), BlackDuckServicesFactory.createDefaultObjectMapper(), null, restConnection, logger, BlackDuckServicesFactory.createDefaultRequestFactory());
    }

    public BlackDuckCompositeService createHubCompositeService() {
        BlackDuckServicesFactory blackDuckServicesFactory = this.createBlackDuckServicesFactory();
        return new BlackDuckCompositeService(blackDuckServicesFactory.getBlackDuckApiClient(), blackDuckServicesFactory.getRequestFactory(), blackDuckServicesFactory.getLogger());
    }
}

