/*
 * Decompiled with CFR 0.152.
 */
package com.versionone.utils;

public class Version
implements Comparable<Version> {
    private int _major = 1;
    private int _minor = 0;
    private int _build = 0;
    private int _revision = 0;

    public int getMajor() {
        return this._major;
    }

    public int getMinor() {
        return this._minor;
    }

    public int getBuild() {
        return this._build;
    }

    public int getRevision() {
        return this._revision;
    }

    public Version() {
    }

    public Version(String value) {
        if (value != null && value.length() > 0) {
            String[] tokens = value.split("\\.");
            this._major = 1 <= tokens.length ? Integer.parseInt(tokens[0]) : 0;
            this._minor = 2 <= tokens.length ? Integer.parseInt(tokens[1]) : 0;
            this._build = 3 <= tokens.length ? Integer.parseInt(tokens[2]) : 0;
            this._revision = 4 <= tokens.length ? Integer.parseInt(tokens[3]) : 0;
        }
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof Version) {
            Version o = (Version)obj;
            return this._major == o._major && this._minor == o._minor && this._build == o._build && this._revision == o._revision;
        }
        return false;
    }

    public String toString() {
        return this._major + "." + this._minor + "." + this._build + "." + this._revision;
    }

    @Override
    public int compareTo(Version other) {
        if (this._major != other._major) {
            return this._major - other._major;
        }
        if (this._minor != other._minor) {
            return this._minor - other._minor;
        }
        if (this._build != other._build) {
            return this._build - other._build;
        }
        if (this._revision != other._revision) {
            return this._revision - other._revision;
        }
        return 0;
    }
}

