/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.integration.blackduck.service.bucket;

import com.synopsys.integration.blackduck.api.core.BlackDuckResponse;
import com.synopsys.integration.blackduck.api.core.response.LinkSingleResponse;
import com.synopsys.integration.blackduck.service.BlackDuckApiClient;
import com.synopsys.integration.blackduck.service.bucket.BlackDuckBucket;
import java.util.Optional;
import java.util.concurrent.Callable;

public class BlackDuckBucketFillTask<T extends BlackDuckResponse>
implements Callable<Optional<T>> {
    private final BlackDuckApiClient blackDuckApiClient;
    private final BlackDuckBucket blackDuckBucket;
    private final LinkSingleResponse<T> linkSingleResponse;

    public BlackDuckBucketFillTask(BlackDuckApiClient blackDuckApiClient, BlackDuckBucket blackDuckBucket, LinkSingleResponse<T> linkSingleResponse) {
        this.blackDuckApiClient = blackDuckApiClient;
        this.blackDuckBucket = blackDuckBucket;
        this.linkSingleResponse = linkSingleResponse;
    }

    @Override
    public Optional<T> call() {
        if (!this.blackDuckBucket.contains(this.linkSingleResponse.getLink())) {
            try {
                T blackDuckResponse = this.blackDuckApiClient.getResponse(this.linkSingleResponse);
                this.blackDuckBucket.addValid(this.linkSingleResponse.getLink(), (BlackDuckResponse)blackDuckResponse);
                return Optional.of(blackDuckResponse);
            }
            catch (Exception e) {
                this.blackDuckBucket.addError(this.linkSingleResponse.getLink(), e);
                return Optional.empty();
            }
        }
        return Optional.ofNullable(this.blackDuckBucket.get(this.linkSingleResponse.getLink(), this.linkSingleResponse.getResponseClass()));
    }
}

