/*
 * Decompiled with CFR 0.152.
 */
package com.versionone;

import com.versionone.Duration;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;

public abstract class DB {
    private static final String NullConversionMessage = "Cannot convert from NULL to non-NULL";
    private static final String _UnknownConversionMessage = "Unsupported conversion from %s";
    private boolean notNull = false;
    public static final NullObject Null = new NullObject();

    private static String UnknownConversionMessage(Object o) {
        return String.format(_UnknownConversionMessage, o == null ? "null" : o.getClass().getName());
    }

    protected DB() {
    }

    public abstract Object getValue();

    public abstract boolean equals(Object var1);

    public int hashCode() {
        return this.isNull() ? Null.hashCode() : this.getValue().hashCode();
    }

    public String toString() {
        return this.isNull() ? Null.toString() : this.getValue().toString();
    }

    public boolean isNull() {
        return !this.notNull;
    }

    void setNotNull(boolean value) {
        this.notNull = value;
    }

    public static class BigInt
    extends DB {
        private Long _value = null;

        public BigInt() {
        }

        public BigInt(Object value) {
            if (value != null && !(value instanceof NullObject)) {
                if (value instanceof String) {
                    String s = (String)value;
                    if (s.length() != 0) {
                        this.setValue(Long.parseLong(s));
                    }
                } else if (value instanceof Number) {
                    this.setValue(((Number)value).longValue());
                } else {
                    throw new RuntimeException(DB.UnknownConversionMessage(value));
                }
            }
        }

        @Override
        public Long getValue() {
            return this.isNull() ? null : this._value;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == null || obj instanceof NullObject) {
                return this.isNull();
            }
            if (obj instanceof BigInt) {
                BigInt other = (BigInt)obj;
                if (other.isNull()) {
                    return this.isNull();
                }
                return !this.isNull() && other._value.equals(this._value);
            }
            if (obj instanceof Long) {
                if (this.isNull()) {
                    return false;
                }
                return this._value.equals((Long)obj);
            }
            return false;
        }

        private void setValue(long value) {
            this._value = new Long(value);
            this.setNotNull(true);
        }
    }

    public static class Real
    extends DB {
        private Double _value = null;

        public Real() {
        }

        public Real(double value) {
            this.setValue(value);
        }

        public Real(Object value) {
            if (value != null && !(value instanceof NullObject)) {
                if (value instanceof String) {
                    String strValue = (String)value;
                    if (0 != strValue.length()) {
                        this.setValue(Float.parseFloat((String)value));
                    }
                } else if (value instanceof Number) {
                    this.setValue(((Number)value).floatValue());
                } else {
                    throw new RuntimeException(DB.UnknownConversionMessage(value));
                }
            }
        }

        @Override
        public Double getValue() {
            return this.isNull() ? null : this._value;
        }

        public float getFloatValue() {
            if (this.isNull()) {
                throw new NullPointerException(DB.NullConversionMessage);
            }
            return this._value.floatValue();
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == null || obj instanceof NullObject) {
                return this.isNull();
            }
            if (obj instanceof Real) {
                Real other = (Real)obj;
                if (other.isNull()) {
                    return this.isNull();
                }
                return !this.isNull() && other._value.equals(this._value);
            }
            if (obj instanceof Double) {
                if (this.isNull()) {
                    return false;
                }
                return this._value.equals(obj);
            }
            return false;
        }

        private void setValue(double value) {
            this._value = new Double(value);
            this.setNotNull(true);
        }
    }

    public static class DateTime
    extends DB
    implements Comparable<DateTime> {
        public static final SimpleDateFormat DAY_N_TIME_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
        public static final SimpleDateFormat DAY_FORMAT = new SimpleDateFormat("yyyy-MM-dd");
        private static final SimpleDateFormat TO_STRING_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        private Date value = null;

        public static DateTime now() {
            return new DateTime(new Date());
        }

        public DateTime() {
        }

        public DateTime(Date value) {
            this.setDate(value);
        }

        public DateTime(Object value) {
            if (value != null && !(value instanceof NullObject)) {
                if (value instanceof String) {
                    String strValue = (String)value;
                    if (!strValue.equals("")) {
                        SimpleDateFormat format = strValue.contains("T") ? DAY_N_TIME_FORMAT : DAY_FORMAT;
                        try {
                            this.setDate(format.parse(strValue));
                        }
                        catch (ParseException e) {
                            throw new RuntimeException("Cannot Parse Value", e);
                        }
                    }
                } else if (value instanceof Date) {
                    this.setDate((Date)value);
                } else if (value instanceof DateTime) {
                    DateTime other = (DateTime)value;
                    if (!other.isNull()) {
                        this.setDate(other.getValue());
                    }
                } else {
                    throw new RuntimeException(DB.UnknownConversionMessage(value));
                }
            }
        }

        @Override
        public Date getValue() {
            return this.isNull() ? null : this.value;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == null || obj instanceof NullObject) {
                return this.isNull();
            }
            if (obj instanceof DateTime) {
                DateTime other = (DateTime)obj;
                if (this.isNull()) {
                    return other.isNull();
                }
                if (other.isNull()) {
                    return false;
                }
                return Math.abs(other.value.getTime() - this.value.getTime()) < 1000L;
            }
            return obj instanceof Date && !this.isNull() && obj.equals(this.value);
        }

        public long toLong() {
            return this.isNull() ? 0L : this.value.getTime();
        }

        private void setDate(Date value) {
            this.value = value;
            this.setNotNull(value != null);
        }

        @Override
        public String toString() {
            return this.getValue() != null ? TO_STRING_FORMAT.format(this.getValue()) : "";
        }

        public Duration subtract(DateTime date) {
            if (this.isNull() || date.isNull()) {
                throw new IllegalStateException("Date has null value");
            }
            Calendar date1 = Calendar.getInstance();
            date1.setTime(this.getValue());
            Calendar date2 = Calendar.getInstance();
            date2.setTime(date.getValue());
            return new Duration(Math.abs(DayCounter.daysUntil(date2, date1)) + " Days");
        }

        public DateTime getDate() {
            if (this.isNull()) {
                return this;
            }
            GregorianCalendar calendar = new GregorianCalendar();
            calendar.setTime(this.getValue());
            calendar.set(11, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            calendar.set(14, 0);
            return new DateTime(calendar.getTime());
        }

        public DateTime add(int field, int value) {
            if (this.isNull()) {
                return this;
            }
            GregorianCalendar calendar = new GregorianCalendar();
            calendar.setTime(this.getValue());
            calendar.add(field, value);
            return new DateTime(calendar.getTime());
        }

        public static Date convertUtcToLocal(Date date) {
            GregorianCalendar calendar = new GregorianCalendar();
            calendar.setTime(date);
            TimeZone local = TimeZone.getDefault();
            calendar.add(14, local.getOffset(date.getTime() + (long)local.getRawOffset()));
            return calendar.getTime();
        }

        public DateTime convertUtcToLocal() {
            return new DateTime(DateTime.convertUtcToLocal(this.getValue()));
        }

        public static Date convertLocalToUtc(Date date) {
            GregorianCalendar calendar = new GregorianCalendar();
            calendar.setTime(date);
            TimeZone local = TimeZone.getDefault();
            calendar.add(14, -local.getOffset(date.getTime()));
            return calendar.getTime();
        }

        public DateTime convertLocalToUtc() {
            return new DateTime(DateTime.convertLocalToUtc(this.getValue()));
        }

        @Override
        public int compareTo(DateTime another) {
            long anotherVal;
            long thisVal = this.getValue().getTime();
            return thisVal < (anotherVal = another.getValue().getTime()) ? -1 : (thisVal == anotherVal ? 0 : 1);
        }

        private static class DayCounter {
            private static final int[] cumulDaysToMonth = new int[]{0, 31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334};

            private DayCounter() {
            }

            public static int daysUntil(Calendar fromDate, Calendar toDate) {
                return DayCounter.daysSinceEpoch(toDate) - DayCounter.daysSinceEpoch(fromDate);
            }

            public static int daysSinceEpoch(Calendar day) {
                int year = day.get(1);
                int month = day.get(2);
                int daysThisYear = cumulDaysToMonth[month] + day.get(5) - 1;
                if (month > 1 && DayCounter.isLeapYear(year)) {
                    ++daysThisYear;
                }
                return DayCounter.daysToYear(year) + daysThisYear;
            }

            public static boolean isLeapYear(int year) {
                return year % 400 == 0 || year % 100 != 0 && year % 4 == 0;
            }

            static int daysToYear(int year) {
                return 365 * year + DayCounter.numLeapsToYear(year);
            }

            static int numLeapsToYear(int year) {
                int num4y = (year - 1) / 4;
                int num100y = (year - 1) / 100;
                int num400y = (year - 1) / 400;
                return num4y - num100y + num400y;
            }
        }
    }

    public static class Str
    extends DB {
        private String value = null;

        public Str() {
        }

        public Str(Object value) {
            if (value != null && !(value instanceof NullObject)) {
                this.setValue(value.toString().trim());
                if (this.value.length() == 0) {
                    this.value = null;
                    this.setNotNull(false);
                }
            }
        }

        private void setValue(String value) {
            this.value = value;
            this.setNotNull(true);
        }

        @Override
        public String getValue() {
            return this.isNull() ? null : this.value;
        }

        @Override
        public boolean equals(Object obj) {
            if (null == obj || obj instanceof NullObject) {
                return this.isNull();
            }
            if (obj instanceof Str) {
                Str other = (Str)obj;
                if (other.isNull()) {
                    return this.isNull();
                }
                return !this.isNull() && other.value.equals(this.value);
            }
            if (obj instanceof String) {
                if (this.isNull()) {
                    return false;
                }
                String other = (String)obj;
                return this.value.equals(other);
            }
            return false;
        }
    }

    public static class Bit
    extends DB {
        private Boolean value = null;

        public Bit() {
        }

        public Bit(boolean value) {
            this.setValue(value);
        }

        public Bit(Object value) {
            if (value != null && !(value instanceof NullObject)) {
                if (value instanceof String) {
                    String s = (String)value;
                    if (s != null && s.length() != 0) {
                        if (s == "0" || s.toLowerCase(Locale.getDefault()) == "false") {
                            this.setValue(false);
                        } else if (s == "1" || s.toLowerCase(Locale.getDefault()) == "true") {
                            this.setValue(true);
                        } else {
                            this.setValue(Boolean.parseBoolean(s));
                        }
                    }
                } else if (value instanceof Boolean) {
                    this.setValue((Boolean)value);
                }
            }
        }

        public Bit(int value) {
            this.setValue(0 != value);
        }

        @Override
        public Boolean getValue() {
            return this.isNull() ? null : this.value;
        }

        public boolean booleanValue() {
            if (this.isNull()) {
                throw new NullPointerException(DB.NullConversionMessage);
            }
            return this.value;
        }

        @Override
        public boolean equals(Object obj) {
            if (null == obj || obj instanceof NullObject) {
                return this.isNull();
            }
            if (obj instanceof Bit) {
                Bit other = (Bit)obj;
                if (other.isNull()) {
                    return this.isNull();
                }
                return !this.isNull() && other.value.equals(this.value);
            }
            if (obj instanceof Boolean) {
                if (this.isNull()) {
                    return false;
                }
                Boolean other = (Boolean)obj;
                return this.value.equals(other);
            }
            return false;
        }

        private void setValue(boolean value) {
            this.value = value;
            this.setNotNull(true);
        }
    }

    public static class Int
    extends DB {
        private Integer value = null;

        public Int() {
        }

        public Int(int value) {
            this.setValue(value);
        }

        public Int(Object value) {
            if (value != null && !(value instanceof NullObject)) {
                if (value instanceof String) {
                    String s = (String)value;
                    if (s != null && s.length() != 0) {
                        this.setValue(Integer.valueOf(s));
                    }
                } else if (value instanceof Number) {
                    this.setValue(((Number)value).intValue());
                }
            }
        }

        @Override
        public Integer getValue() {
            return this.isNull() ? null : this.value;
        }

        public static boolean compare(Int a, Int b) {
            return a.isNull() ? b.isNull() : b.isNull() && a.value == b.value;
        }

        @Override
        public boolean equals(Object obj) {
            if (null == obj || obj instanceof NullObject) {
                return this.isNull();
            }
            if (obj instanceof Int) {
                Int other = (Int)obj;
                if (other.isNull()) {
                    return this.isNull();
                }
                return !this.isNull() && other.value.equals(this.value);
            }
            if (obj instanceof Integer) {
                if (this.isNull()) {
                    return false;
                }
                Integer other = (Integer)obj;
                return this.value.equals(other);
            }
            return false;
        }

        public int intValue() {
            if (this.isNull()) {
                throw new NullPointerException(DB.NullConversionMessage);
            }
            return this.value;
        }

        public long longValue() {
            if (this.isNull()) {
                throw new NullPointerException(DB.NullConversionMessage);
            }
            return this.value.longValue();
        }

        private void setValue(int i) {
            this.value = i;
            this.setNotNull(true);
        }
    }

    public static class NullObject
    extends DB {
        private NullObject() {
        }

        @Override
        public boolean equals(Object obj) {
            if (null == obj) {
                return true;
            }
            if (obj instanceof NullObject) {
                return true;
            }
            if (obj instanceof DB) {
                DB other = (DB)obj;
                return null == other.getValue() && other.isNull();
            }
            return false;
        }

        @Override
        public Object getValue() {
            return null;
        }

        @Override
        public int hashCode() {
            return 0;
        }

        @Override
        public String toString() {
            return "";
        }
    }
}

