/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.spring.configuration;

import com.xebialabs.deployit.ServerConfiguration;
import com.xebialabs.deployit.security.SpringSessionConverterFactory;
import com.xebialabs.xlrelease.config.XlrConfig;
import com.xebialabs.xlrelease.db.sql.DatabaseInfo;
import com.xebialabs.xlrelease.repository.SpringSessionRepository;
import java.util.EnumSet;
import javax.servlet.DispatcherType;
import javax.sql.DataSource;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.core.convert.support.GenericConversionService;
import org.springframework.core.serializer.support.DeserializingConverter;
import org.springframework.core.serializer.support.SerializingConverter;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.SchedulingConfigurer;
import org.springframework.scheduling.config.ScheduledTaskRegistrar;
import org.springframework.security.core.session.SessionRegistry;
import org.springframework.session.FindByIndexNameSessionRepository;
import org.springframework.session.config.SessionRepositoryCustomizer;
import org.springframework.session.jdbc.Db2JdbcIndexedSessionRepositoryCustomizer;
import org.springframework.session.jdbc.JdbcIndexedSessionRepository;
import org.springframework.session.jdbc.MySqlJdbcIndexedSessionRepositoryCustomizer;
import org.springframework.session.jdbc.OracleJdbcIndexedSessionRepositoryCustomizer;
import org.springframework.session.jdbc.PostgreSqlJdbcIndexedSessionRepositoryCustomizer;
import org.springframework.session.jdbc.SqlServerJdbcIndexedSessionRepositoryCustomizer;
import org.springframework.session.jdbc.config.annotation.SpringSessionDataSource;
import org.springframework.session.jdbc.config.annotation.web.http.JdbcHttpSessionConfiguration;
import org.springframework.session.security.SpringSessionBackedSessionRegistry;
import org.springframework.session.web.http.SessionRepositoryFilter;
import org.springframework.transaction.PlatformTransactionManager;

@Configuration
@ConditionalOnProperty(value={"xl.server.session.storage.enabled"}, havingValue="true")
public class SpringSessionConfiguration
extends JdbcHttpSessionConfiguration {
    private final DatabaseInfo dbInfo;
    private final SpringSessionConverterFactory converterFactory;
    private final String cleanupCron;
    private ClassLoader classLoader;

    public SpringSessionConfiguration(@Autowired XlrConfig xlrConfig, @Autowired @Qualifier(value="xlrDbInfo") DatabaseInfo dbInfo, @Autowired ServerConfiguration serverConfiguration, @Autowired(required=false) SpringSessionConverterFactory converterFactory) {
        this.dbInfo = dbInfo;
        this.converterFactory = converterFactory;
        int sessionTimeoutSeconds = serverConfiguration.getClientSessionTimeoutMinutes() * 60;
        int maxInactiveInterval = sessionTimeoutSeconds == 0 ? 2592000 : sessionTimeoutSeconds;
        super.setMaxInactiveIntervalInSeconds(Integer.valueOf(maxInactiveInterval));
        this.cleanupCron = xlrConfig.server_session_storage_cleanupCron();
        super.setCleanupCron(this.cleanupCron);
    }

    @Autowired
    public void setDataSource(@SpringSessionDataSource ObjectProvider<DataSource> springSessionDataSource, @Qualifier(value="xlrRepositoryDataSourceProxy") ObjectProvider<DataSource> dataSource) {
        super.setDataSource(springSessionDataSource, dataSource);
    }

    @Autowired
    public void setTransactionManager(@Qualifier(value="xlrRepositoryTransactionManager") PlatformTransactionManager transactionManager) {
        super.setTransactionManager(transactionManager);
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        super.setBeanClassLoader(classLoader);
        this.classLoader = classLoader;
    }

    @Bean
    public JdbcIndexedSessionRepository sessionRepository() {
        JdbcIndexedSessionRepository repo = super.sessionRepository();
        GenericConversionService conversionService = this.createConversionServiceWithBeanClassLoader();
        repo.setConversionService((ConversionService)conversionService);
        return repo;
    }

    @Bean
    public SessionRegistry sessionRegistry() {
        return new SpringSessionBackedSessionRegistry((FindByIndexNameSessionRepository)this.sessionRepository());
    }

    @Bean
    public SessionRepositoryCustomizer<JdbcIndexedSessionRepository> sessionRepositoryCustomizer() {
        if (this.dbInfo instanceof DatabaseInfo.Db2) {
            return new Db2JdbcIndexedSessionRepositoryCustomizer();
        }
        if (this.dbInfo instanceof DatabaseInfo.Oracle) {
            return new OracleJdbcIndexedSessionRepositoryCustomizer();
        }
        if (this.dbInfo instanceof DatabaseInfo.MsSqlServer) {
            return new SqlServerJdbcIndexedSessionRepositoryCustomizer();
        }
        if (this.dbInfo instanceof DatabaseInfo.MySql) {
            return new MySqlJdbcIndexedSessionRepositoryCustomizer();
        }
        if (this.dbInfo instanceof DatabaseInfo.PostgreSql) {
            return new PostgreSqlJdbcIndexedSessionRepositoryCustomizer();
        }
        return null;
    }

    @Bean
    public FilterRegistrationBean<SessionRepositoryFilter<?>> sessionRepositoryFilterRegistration(SessionRepositoryFilter<?> filter) {
        FilterRegistrationBean registration = new FilterRegistrationBean(filter, new ServletRegistrationBean[0]);
        registration.setDispatcherTypes(EnumSet.of(DispatcherType.ASYNC, DispatcherType.ERROR, DispatcherType.REQUEST));
        registration.setOrder(-2147483598);
        return registration;
    }

    private GenericConversionService createConversionServiceWithBeanClassLoader() {
        DefaultConversionService conversionService = new DefaultConversionService();
        if (this.converterFactory != null) {
            conversionService.addConverter(this.converterFactory.buildSerializer(this.classLoader));
            conversionService.addConverter(this.converterFactory.buildDeserializer(this.classLoader));
        } else {
            conversionService.addConverter(Object.class, byte[].class, (Converter)new SerializingConverter());
            conversionService.addConverter(byte[].class, Object.class, (Converter)new DeserializingConverter(this.classLoader));
        }
        return conversionService;
    }

    @EnableScheduling
    @Configuration(proxyBeanMethods=false)
    class EmptyPrincipalCleanupConfiguration
    implements SchedulingConfigurer {
        private final SpringSessionRepository springSessionRepository;

        EmptyPrincipalCleanupConfiguration(SpringSessionRepository springSessionRepository) {
            this.springSessionRepository = springSessionRepository;
        }

        public void configureTasks(ScheduledTaskRegistrar taskRegistrar) {
            long delayDuration = 300000L;
            taskRegistrar.addFixedDelayTask(this.springSessionRepository::cleanUpSessionsWithEmptyPrincipal, delayDuration);
        }
    }
}

