/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.scheduler.converters;

import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.scheduler.CreateReleaseTaskJob;
import com.xebialabs.xlrelease.scheduler.CustomScriptTaskJob;
import com.xebialabs.xlrelease.scheduler.FacetCheckJob;
import com.xebialabs.xlrelease.scheduler.FailureHandlerJob;
import com.xebialabs.xlrelease.scheduler.JobRow;
import com.xebialabs.xlrelease.scheduler.JobType;
import com.xebialabs.xlrelease.scheduler.NextCustomScriptTaskJob;
import com.xebialabs.xlrelease.scheduler.NotificationTaskJob;
import com.xebialabs.xlrelease.scheduler.PreconditionJob;
import com.xebialabs.xlrelease.scheduler.ScriptTaskJob;
import com.xebialabs.xlrelease.scheduler.TaskJob;
import com.xebialabs.xlrelease.script.TaskSoftReferenceFactory;
import com.xebialabs.xlrelease.service.ReleaseService;
import org.springframework.stereotype.Component;
import scala.reflect.ScalaSignature;

@Component
@ScalaSignature(bytes="\u0006\u0005\u00153A\u0001B\u0003\u0001!!Aq\u0003\u0001B\u0001B\u0003%\u0001\u0004C\u0003\u001f\u0001\u0011\u0005q\u0004C\u0003$\u0001\u0011\u0005AE\u0001\tUCN\\'j\u001c2D_:4XM\u001d;fe*\u0011aaB\u0001\u000bG>tg/\u001a:uKJ\u001c(B\u0001\u0005\n\u0003%\u00198\r[3ek2,'O\u0003\u0002\u000b\u0017\u0005I\u0001\u0010\u001c:fY\u0016\f7/\u001a\u0006\u0003\u00195\t\u0011\u0002_3cS\u0006d\u0017MY:\u000b\u00039\t1aY8n\u0007\u0001\u0019\"\u0001A\t\u0011\u0005I)R\"A\n\u000b\u0003Q\tQa]2bY\u0006L!AF\n\u0003\r\u0005s\u0017PU3g\u00039\u0011X\r\\3bg\u0016\u001cVM\u001d<jG\u0016\u0004\"!\u0007\u000f\u000e\u0003iQ!aG\u0005\u0002\u000fM,'O^5dK&\u0011QD\u0007\u0002\u000f%\u0016dW-Y:f'\u0016\u0014h/[2f\u0003\u0019a\u0014N\\5u}Q\u0011\u0001E\t\t\u0003C\u0001i\u0011!\u0002\u0005\u0006/\t\u0001\r\u0001G\u0001\u000bMJ|WNS8c%><HCA\u00136a\t1C\u0006E\u0002(Q)j\u0011aB\u0005\u0003S\u001d\u0011q\u0001V1tW*{'\r\u0005\u0002,Y1\u0001A!C\u0017\u0004\u0003\u0003\u0005\tQ!\u0001/\u0005\ryF%M\t\u0003_I\u0002\"A\u0005\u0019\n\u0005E\u001a\"a\u0002(pi\"Lgn\u001a\t\u0003%MJ!\u0001N\n\u0003\u0007\u0005s\u0017\u0010C\u00037\u0007\u0001\u0007q'\u0001\u0004k_\n\u0014vn\u001e\t\u0003OaJ!!O\u0004\u0003\r){'MU8xQ\t\u00011\b\u0005\u0002=\u00076\tQH\u0003\u0002?\u007f\u0005Q1\u000f^3sK>$\u0018\u0010]3\u000b\u0005\u0001\u000b\u0015aD:qe&twM\u001a:b[\u0016<xN]6\u000b\u0003\t\u000b1a\u001c:h\u0013\t!UHA\u0005D_6\u0004xN\\3oi\u0002")
public class TaskJobConverter {
    private final ReleaseService releaseService;

    public TaskJob<?> fromJobRow(JobRow jobRow) {
        TaskJob<Task> taskJob;
        JobType jobType = jobRow.jobType();
        if (((Object)((Object)JobType.PRECONDITION)).equals((Object)jobType)) {
            taskJob = new PreconditionJob(TaskSoftReferenceFactory.taskRef(this.releaseService, jobRow.taskId(), jobRow.executionId(), jobRow.releaseUid()));
        } else if (((Object)((Object)JobType.FACET_CHECK)).equals((Object)jobType)) {
            taskJob = new FacetCheckJob(TaskSoftReferenceFactory.taskRef(this.releaseService, jobRow.taskId(), jobRow.executionId(), jobRow.releaseUid()));
        } else if (((Object)((Object)JobType.FAILURE_HANDLER)).equals((Object)jobType)) {
            taskJob = new FailureHandlerJob(TaskSoftReferenceFactory.taskRef(this.releaseService, jobRow.taskId(), jobRow.executionId(), jobRow.releaseUid()));
        } else if (((Object)((Object)JobType.CUSTOM_SCRIPT_TASK)).equals((Object)jobType)) {
            taskJob = new CustomScriptTaskJob(TaskSoftReferenceFactory.taskRef(this.releaseService, jobRow.taskId(), jobRow.executionId(), jobRow.releaseUid()));
        } else if (((Object)((Object)JobType.NEXT_CUSTOM_SCRIPT_TASK)).equals((Object)jobType)) {
            taskJob = new NextCustomScriptTaskJob(TaskSoftReferenceFactory.taskRef(this.releaseService, jobRow.taskId(), jobRow.executionId(), jobRow.releaseUid()), jobRow.scheduledStartTime());
        } else if (((Object)((Object)JobType.SCRIPT_TASK)).equals((Object)jobType)) {
            taskJob = new ScriptTaskJob(TaskSoftReferenceFactory.taskRef(this.releaseService, jobRow.taskId(), jobRow.executionId(), jobRow.releaseUid()));
        } else if (((Object)((Object)JobType.CREATE_RELEASE_TASK)).equals((Object)jobType)) {
            taskJob = new CreateReleaseTaskJob(TaskSoftReferenceFactory.taskRef(this.releaseService, jobRow.taskId(), jobRow.executionId(), jobRow.releaseUid()));
        } else if (((Object)((Object)JobType.NOTIFICATION_TASK)).equals((Object)jobType)) {
            taskJob = new NotificationTaskJob(TaskSoftReferenceFactory.taskRef(this.releaseService, jobRow.taskId(), jobRow.executionId(), jobRow.releaseUid()));
        } else {
            throw new IllegalStateException(new StringBuilder(38).append("'").append((Object)jobRow.jobType()).append("' is not a valid job type for TaskJob").toString());
        }
        TaskJob<Task> job = taskJob;
        job.id_$eq(jobRow.id());
        job.node_$eq(jobRow.node());
        job.status_$eq(jobRow.status());
        job.version_$eq(jobRow.version());
        job.submitTime_$eq(jobRow.submitTime());
        job.startTime_$eq(jobRow.startTime());
        return job;
    }

    public TaskJobConverter(ReleaseService releaseService) {
        this.releaseService = releaseService;
    }
}

