/*
 * Decompiled with CFR 0.152.
 */
package org.jparsec;

import org.jparsec.ParseContext;
import org.jparsec.Parser;

final class SkipTimesParser
extends Parser<Void> {
    private final Parser<?> parser;
    private final int min;
    private final int max;

    SkipTimesParser(Parser<?> parser, int min, int max) {
        this.parser = parser;
        this.min = min;
        this.max = max;
    }

    @Override
    boolean apply(ParseContext ctxt) {
        if (!ctxt.repeat(this.parser, this.min)) {
            return false;
        }
        if (this.repeatAtMost(this.max - this.min, ctxt)) {
            ctxt.result = null;
            return true;
        }
        return false;
    }

    public String toString() {
        return "skipTimes";
    }

    private boolean repeatAtMost(int times, ParseContext ctxt) {
        for (int i = 0; i < times; ++i) {
            int physical = ctxt.at;
            int logical = ctxt.step;
            if (this.parser.apply(ctxt)) continue;
            ctxt.setAt(logical, physical);
            return true;
        }
        return true;
    }
}

