/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.integration.blackduck.codelocation.signaturescanner;

import com.synopsys.integration.blackduck.codelocation.signaturescanner.ScanBatchBuilder;
import com.synopsys.integration.blackduck.codelocation.signaturescanner.command.BlackDuckOnlineProperties;
import com.synopsys.integration.blackduck.codelocation.signaturescanner.command.IndividualFileMatching;
import com.synopsys.integration.blackduck.codelocation.signaturescanner.command.ScanCommand;
import com.synopsys.integration.blackduck.codelocation.signaturescanner.command.ScanPathsUtility;
import com.synopsys.integration.blackduck.codelocation.signaturescanner.command.ScanTarget;
import com.synopsys.integration.blackduck.codelocation.signaturescanner.command.SnippetMatching;
import com.synopsys.integration.blackduck.exception.BlackDuckIntegrationException;
import com.synopsys.integration.builder.Buildable;
import com.synopsys.integration.rest.HttpUrl;
import com.synopsys.integration.rest.proxy.ProxyInfo;
import com.synopsys.integration.util.IntEnvironmentVariables;
import com.synopsys.integration.util.Stringable;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class ScanBatch
extends Stringable
implements Buildable {
    private final boolean cleanupOutput;
    private final HttpUrl blackDuckUrl;
    private final BlackDuckOnlineProperties blackDuckOnlineProperties;
    private final List<ScanTarget> scanTargets;
    private final String blackDuckUsername;
    private final String blackDuckPassword;
    private final String blackDuckApiToken;
    private final File signatureScannerInstallDirectory;
    private final File outputDirectory;
    private final int scanMemoryInMegabytes;
    private final String scanCliOpts;
    private final String additionalScanArguments;
    private final boolean runInsecure;
    private final boolean dryRun;
    private final ProxyInfo proxyInfo;
    private final String projectName;
    private final String projectVersionName;
    private final IndividualFileMatching individualFileMatching;
    private final boolean debug;
    private final boolean verbose;

    public static ScanBatchBuilder newBuilder() {
        return new ScanBatchBuilder();
    }

    public ScanBatch(File signatureScannerInstallDirectory, File outputDirectory, boolean cleanupOutput, int scanMemoryInMegabytes, boolean dryRun, boolean debug, boolean verbose, String scanCliOpts, String additionalScanArguments, BlackDuckOnlineProperties blackDuckOnlineProperties, IndividualFileMatching individualFileMatching, HttpUrl blackDuckUrl, String blackDuckUsername, String blackDuckPassword, String blackDuckApiToken, ProxyInfo proxyInfo, boolean runInsecure, String projectName, String projectVersionName, List<ScanTarget> scanTargets) {
        this.signatureScannerInstallDirectory = signatureScannerInstallDirectory;
        this.outputDirectory = outputDirectory;
        this.cleanupOutput = cleanupOutput;
        this.scanMemoryInMegabytes = scanMemoryInMegabytes;
        this.dryRun = dryRun;
        this.debug = debug;
        this.verbose = verbose;
        this.scanCliOpts = scanCliOpts;
        this.additionalScanArguments = additionalScanArguments;
        this.blackDuckOnlineProperties = blackDuckOnlineProperties;
        this.individualFileMatching = individualFileMatching;
        this.blackDuckUrl = blackDuckUrl;
        this.blackDuckUsername = blackDuckUsername;
        this.blackDuckPassword = blackDuckPassword;
        this.blackDuckApiToken = blackDuckApiToken;
        this.proxyInfo = proxyInfo;
        this.runInsecure = runInsecure;
        this.projectName = projectName;
        this.projectVersionName = projectVersionName;
        this.scanTargets = scanTargets;
    }

    public List<ScanCommand> createScanCommands(File defaultInstallDirectory, ScanPathsUtility scanPathsUtility, IntEnvironmentVariables intEnvironmentVariables) throws BlackDuckIntegrationException {
        String scanCliOptsEnvironment;
        String scanCliOptsToUse = this.scanCliOpts;
        if (null != intEnvironmentVariables && StringUtils.isBlank((CharSequence)scanCliOptsToUse) && StringUtils.isNotBlank((CharSequence)(scanCliOptsEnvironment = intEnvironmentVariables.getValue("SCAN_CLI_OPTS")))) {
            scanCliOptsToUse = scanCliOptsEnvironment;
        }
        boolean commandDryRun = this.blackDuckUrl == null || this.dryRun;
        String commandScheme = null;
        String commandHost = null;
        int commandPort = 0;
        if (!commandDryRun) {
            URL url = this.blackDuckUrl.url();
            commandScheme = url.getProtocol();
            commandHost = url.getHost();
            if (url.getPort() > 0) {
                commandPort = url.getPort();
            } else if (url.getDefaultPort() > 0) {
                commandPort = url.getDefaultPort();
            }
        }
        ArrayList<ScanCommand> scanCommands = new ArrayList<ScanCommand>();
        for (ScanTarget scanTarget : this.scanTargets) {
            this.addToScanCommands(defaultInstallDirectory, scanPathsUtility, scanCliOptsToUse, commandDryRun, this.blackDuckOnlineProperties, commandScheme, commandHost, commandPort, scanCommands, scanTarget);
        }
        return scanCommands;
    }

    private void addToScanCommands(File defaultInstallDirectory, ScanPathsUtility scanPathsUtility, String scanCliOptsToUse, boolean commandDryRun, BlackDuckOnlineProperties blackDuckOnlineProperties, String commandScheme, String commandHost, int commandPort, List<ScanCommand> scanCommands, ScanTarget scanTarget) throws BlackDuckIntegrationException {
        File commandOutputDirectory = scanTarget.determineCommandOutputDirectory(scanPathsUtility, this.outputDirectory);
        File installDirectoryForCommand = this.signatureScannerInstallDirectory;
        if (null == installDirectoryForCommand && null != defaultInstallDirectory) {
            installDirectoryForCommand = defaultInstallDirectory;
        }
        ScanCommand scanCommand = new ScanCommand(installDirectoryForCommand, commandOutputDirectory, commandDryRun, this.proxyInfo, scanCliOptsToUse, this.scanMemoryInMegabytes, commandScheme, commandHost, this.blackDuckApiToken, this.blackDuckUsername, this.blackDuckPassword, commandPort, this.runInsecure, scanTarget.getCodeLocationName(), blackDuckOnlineProperties, this.individualFileMatching, scanTarget.getExclusionPatterns(), this.additionalScanArguments, scanTarget.getPath(), this.verbose, this.debug, this.projectName, this.projectVersionName);
        scanCommands.add(scanCommand);
    }

    public File getSignatureScannerInstallDirectory() {
        return this.signatureScannerInstallDirectory;
    }

    public File getOutputDirectory() {
        return this.outputDirectory;
    }

    public boolean isCleanupOutput() {
        return this.cleanupOutput;
    }

    public int getScanMemoryInMegabytes() {
        return this.scanMemoryInMegabytes;
    }

    public boolean isDryRun() {
        return this.dryRun;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public String getScanCliOpts() {
        return this.scanCliOpts;
    }

    public String getAdditionalScanArguments() {
        return this.additionalScanArguments;
    }

    public SnippetMatching getSnippetMatchingMode() {
        return this.blackDuckOnlineProperties.getSnippetMatchingMode();
    }

    public boolean isUploadSource() {
        return this.blackDuckOnlineProperties.isUploadSource();
    }

    public boolean isLicenseSearch() {
        return this.blackDuckOnlineProperties.isLicenseSearch();
    }

    public IndividualFileMatching getIndividualFileMatching() {
        return this.individualFileMatching;
    }

    public HttpUrl getBlackDuckUrl() {
        return this.blackDuckUrl;
    }

    public String getBlackDuckUsername() {
        return this.blackDuckUsername;
    }

    public String getBlackDuckPassword() {
        return this.blackDuckPassword;
    }

    public String getBlackDuckApiToken() {
        return this.blackDuckApiToken;
    }

    public ProxyInfo getProxyInfo() {
        return this.proxyInfo;
    }

    public boolean isRunInsecure() {
        return this.runInsecure;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public String getProjectVersionName() {
        return this.projectVersionName;
    }

    public List<ScanTarget> getScanTargets() {
        return this.scanTargets;
    }
}

