/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.webhooks.github;

import com.xebialabs.deployit.util.PasswordEncrypter;
import com.xebialabs.xlplatform.webhooks.authentication.RequestAuthenticationMethod;
import com.xebialabs.xlplatform.webhooks.domain.Endpoint;
import com.xebialabs.xlrelease.webhooks.github.GithubAuthentication;
import com.xebialabs.xlrelease.webhooks.github.GithubAuthenticationMethod$;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logger$;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Hex;
import scala.Function0;
import scala.Function1;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.util.Failure;
import scala.util.Try;
import scala.util.Try$;

public final class GithubAuthenticationMethod$
implements RequestAuthenticationMethod {
    public static final GithubAuthenticationMethod$ MODULE$ = new GithubAuthenticationMethod$();
    private static Logger logger;
    private static PasswordEncrypter passwordEncrypter;
    private static final String SIGNATURE_HEADER;
    private static final String SIGNATURE_PREFIX;
    private static final String HMAC_SHA1_ALGORITHM;
    private static volatile byte bitmap$0;

    static {
        RequestAuthenticationMethod.$init$((RequestAuthenticationMethod)MODULE$);
        SIGNATURE_HEADER = "X-Hub-Signature";
        SIGNATURE_PREFIX = "sha1=";
        HMAC_SHA1_ALGORITHM = "HmacSHA1";
    }

    public boolean authenticate(Endpoint endpoint, java.util.Map<String, String> headers, java.util.Map<String, String[]> params, String payload) {
        return RequestAuthenticationMethod.authenticate$((RequestAuthenticationMethod)this, (Endpoint)endpoint, headers, params, (String)payload);
    }

    public String SIGNATURE_HEADER() {
        return SIGNATURE_HEADER;
    }

    public String SIGNATURE_PREFIX() {
        return SIGNATURE_PREFIX;
    }

    public String HMAC_SHA1_ALGORITHM() {
        return HMAC_SHA1_ALGORITHM;
    }

    private Logger logger$lzycompute() {
        GithubAuthenticationMethod$ githubAuthenticationMethod$ = this;
        synchronized (githubAuthenticationMethod$) {
            if ((byte)(bitmap$0 & 1) == 0) {
                logger = Logger$.MODULE$.apply(StringOps$.MODULE$.dropRight$extension(Predef$.MODULE$.augmentString(this.getClass().getName()), 1));
                bitmap$0 = (byte)(bitmap$0 | 1);
            }
        }
        return logger;
    }

    public Logger logger() {
        if ((byte)(bitmap$0 & 1) == 0) {
            return this.logger$lzycompute();
        }
        return logger;
    }

    private PasswordEncrypter passwordEncrypter$lzycompute() {
        GithubAuthenticationMethod$ githubAuthenticationMethod$ = this;
        synchronized (githubAuthenticationMethod$) {
            if ((byte)(bitmap$0 & 2) == 0) {
                passwordEncrypter = PasswordEncrypter.getInstance();
                bitmap$0 = (byte)(bitmap$0 | 2);
            }
        }
        return passwordEncrypter;
    }

    public PasswordEncrypter passwordEncrypter() {
        if ((byte)(bitmap$0 & 2) == 0) {
            return this.passwordEncrypter$lzycompute();
        }
        return passwordEncrypter;
    }

    public boolean authenticateScala(Endpoint endpoint, Map<String, String> headers, Map<String, String[]> params, String payload) {
        Try authentication = this.getSignature(headers).flatMap((Function1 & Serializable)signature -> MODULE$.getKey((GithubAuthentication)endpoint.authentication()).flatMap((Function1 & Serializable)key -> MODULE$.computeSignature(payload, (SecretKeySpec)key).map((Function1 & Serializable)computed -> BoxesRunTime.boxToBoolean((boolean)GithubAuthenticationMethod$.$anonfun$authenticateScala$3(signature, computed)))));
        return BoxesRunTime.unboxToBoolean((Object)authentication.recover((PartialFunction)new Serializable(){
            private static final long serialVersionUID = 0L;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                Option$.MODULE$.apply((Object)A1.getMessage()).foreach((Function1 & Serializable)x$1 -> {
                    anonfun.authenticateScala.5.$anonfun$applyOrElse$1(x$1);
                    return BoxedUnit.UNIT;
                });
                return (B1)BoxesRunTime.boxToBoolean((boolean)false);
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                return true;
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$1(String x$1) {
                GithubAuthenticationMethod$.MODULE$.logger().warn((Function0 & Serializable)() -> x$1);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1$adapted(java.lang.String ), $anonfun$applyOrElse$2(java.lang.String )}, serializedLambda);
            }
        }).get());
    }

    public Try<byte[]> getSignature(Map<String, String> headers) {
        return (Try)headers.get((Object)this.SIGNATURE_HEADER()).collect((PartialFunction)new Serializable(){
            private static final long serialVersionUID = 0L;

            public final <A1 extends String, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1.startsWith(GithubAuthenticationMethod$.MODULE$.SIGNATURE_PREFIX())) {
                    GithubAuthenticationMethod$.MODULE$.logger().trace((Function0 & Serializable)() -> new StringBuilder(15).append("Got signature: ").append(A1).toString());
                    return (B1)Try$.MODULE$.apply((Function0 & Serializable)() -> Hex.decodeHex((String)StringOps$.MODULE$.drop$extension(Predef$.MODULE$.augmentString(A1), GithubAuthenticationMethod$.MODULE$.SIGNATURE_PREFIX().length())));
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(String x1) {
                String string = x1;
                return string.startsWith(GithubAuthenticationMethod$.MODULE$.SIGNATURE_PREFIX());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$3(java.lang.String ), $anonfun$applyOrElse$4(java.lang.String )}, serializedLambda);
            }
        }).getOrElse((Function0 & Serializable)() -> new Failure((Throwable)new IllegalArgumentException(new StringBuilder(20).append("Header '").append(MODULE$.SIGNATURE_HEADER()).append("' not found.").toString())));
    }

    public Try<SecretKeySpec> getKey(GithubAuthentication requestAuthenticationConfig) {
        return (Try)Option$.MODULE$.apply((Object)requestAuthenticationConfig.githubSecret()).collect((PartialFunction)new Serializable(){
            private static final long serialVersionUID = 0L;

            public final <A1 extends String, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(A1))) {
                    GithubAuthenticationMethod$.MODULE$.logger().trace((Function0 & Serializable)() -> new StringBuilder(14).append("githubSecret: ").append(A1).toString());
                    return (B1)Try$.MODULE$.apply((Function0 & Serializable)() -> new SecretKeySpec(GithubAuthenticationMethod$.MODULE$.passwordEncrypter().decrypt(A1).getBytes(), GithubAuthenticationMethod$.MODULE$.HMAC_SHA1_ALGORITHM()));
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(String x1) {
                String string = x1;
                return StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(string));
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$5(java.lang.String ), $anonfun$applyOrElse$6(java.lang.String )}, serializedLambda);
            }
        }).getOrElse((Function0 & Serializable)() -> new Failure((Throwable)new IllegalStateException(new StringBuilder(34).append("'").append((Object)requestAuthenticationConfig).append("' has no githubSecret configured!").toString())));
    }

    public Try<byte[]> computeSignature(String payload, SecretKeySpec key) {
        return Try$.MODULE$.apply((Function0 & Serializable)() -> {
            Mac hmac = Mac.getInstance(MODULE$.HMAC_SHA1_ALGORITHM());
            hmac.init(key);
            return hmac.doFinal(payload.replace("\r\n", "\n").getBytes(StandardCharsets.UTF_8));
        });
    }

    public static final /* synthetic */ boolean $anonfun$authenticateScala$3(byte[] signature$1, byte[] computed) {
        MODULE$.logger().trace((Function0 & Serializable)() -> new StringBuilder(10).append("computed: ").append(Predef$.MODULE$.wrapCharArray(Hex.encodeHex((byte[])computed)).mkString("")).toString());
        return MessageDigest.isEqual(computed, signature$1);
    }

    private GithubAuthenticationMethod$() {
    }
}

