/*
 * Decompiled with CFR 0.152.
 */
package akka.cluster.sharding.internal;

import akka.annotation.InternalApi;
import akka.cluster.sharding.ClusterShardingSettings;
import akka.cluster.sharding.internal.ActiveEntities;
import akka.cluster.sharding.internal.LeastFrequentlyUsedReplacementPolicy;
import akka.cluster.sharding.internal.LeastRecentlyUsedReplacementPolicy;
import akka.cluster.sharding.internal.MostRecentlyUsedReplacementPolicy;
import akka.cluster.sharding.internal.NoActiveEntities$;
import akka.cluster.sharding.internal.SegmentedLeastRecentlyUsedReplacementPolicy;
import scala.collection.immutable.Seq;

@InternalApi
public final class ActiveEntities$ {
    public static final ActiveEntities$ MODULE$ = new ActiveEntities$();

    public ActiveEntities apply(ClusterShardingSettings.PassivationStrategy strategy, boolean idleEnabled) {
        ActiveEntities activeEntities;
        ClusterShardingSettings.PassivationStrategy passivationStrategy = strategy;
        if (passivationStrategy instanceof ClusterShardingSettings.LeastRecentlyUsedPassivationStrategy) {
            ClusterShardingSettings.LeastRecentlyUsedPassivationStrategy leastRecentlyUsedPassivationStrategy = (ClusterShardingSettings.LeastRecentlyUsedPassivationStrategy)passivationStrategy;
            Seq<Object> segmented = leastRecentlyUsedPassivationStrategy.segmented();
            activeEntities = segmented.isEmpty() ? new LeastRecentlyUsedReplacementPolicy(0) : new SegmentedLeastRecentlyUsedReplacementPolicy(0, segmented, idleEnabled);
        } else if (passivationStrategy instanceof ClusterShardingSettings.MostRecentlyUsedPassivationStrategy) {
            activeEntities = new MostRecentlyUsedReplacementPolicy(0);
        } else if (passivationStrategy instanceof ClusterShardingSettings.LeastFrequentlyUsedPassivationStrategy) {
            ClusterShardingSettings.LeastFrequentlyUsedPassivationStrategy leastFrequentlyUsedPassivationStrategy = (ClusterShardingSettings.LeastFrequentlyUsedPassivationStrategy)passivationStrategy;
            boolean dynamicAging = leastFrequentlyUsedPassivationStrategy.dynamicAging();
            activeEntities = new LeastFrequentlyUsedReplacementPolicy(0, dynamicAging, idleEnabled);
        } else {
            activeEntities = NoActiveEntities$.MODULE$;
        }
        return activeEntities;
    }

    private ActiveEntities$() {
    }
}

