/*
 * Decompiled with CFR 0.152.
 */
package com.jeta.forms.store.jml;

import com.jeta.forms.store.jml.InlineJMLSerializer;
import com.jeta.forms.store.jml.JMLException;
import com.jeta.forms.store.jml.JMLSerializer;
import com.jeta.forms.store.jml.JMLSerializerFactory;
import com.jeta.forms.store.jml.PrimitiveHolder;
import com.jeta.forms.store.jml.dom.DefaultXMLDocument;
import com.jeta.forms.store.jml.dom.JMLDocument;
import com.jeta.forms.store.jml.dom.JMLNode;
import com.jeta.forms.store.xml.parser.CustomSAXException;
import com.jeta.forms.store.xml.parser.MainHandler;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class JMLUtils {
    static final /* synthetic */ boolean $assertionsDisabled;

    public static void verifyObjectType(Object object, Class clazz) throws JMLException {
        if (object != null && object.getClass() != clazz) {
            throw new JMLException("Verify object class failed.  Expecting: " + clazz + "  but got: " + object.getClass());
        }
    }

    public static JMLNode writeObject(Object object) throws JMLException {
        try {
            JMLSerializer jMLSerializer = JMLSerializerFactory.getInstance().createSerializer(object);
            if (!$assertionsDisabled && jMLSerializer == null) {
                throw new AssertionError();
            }
            return jMLSerializer.serialize(new DefaultXMLDocument(), object);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new JMLException(exception);
        }
    }

    public static Object readObject(InputStream inputStream) throws JMLException {
        try {
            SAXParser sAXParser = SAXParserFactory.newInstance().newSAXParser();
            MainHandler mainHandler = new MainHandler();
            sAXParser.parse(inputStream, (DefaultHandler)mainHandler);
            return mainHandler.getObject();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new JMLException(exception);
        }
    }

    public static JMLNode createObjectNode2(JMLDocument jMLDocument, String string) {
        JMLNode jMLNode = jMLDocument.createNode("object");
        if (string == null) {
            jMLNode.setAttribute("classname", "null");
        } else {
            jMLNode.setAttribute("classname", string);
        }
        return jMLNode;
    }

    public static JMLNode createObjectNode(JMLDocument jMLDocument, Object object) {
        JMLNode jMLNode = jMLDocument.createNode("object");
        if (object == null) {
            jMLNode.setAttribute("classname", "null");
        } else {
            jMLNode.setAttribute("classname", object.getClass().getName());
        }
        return jMLNode;
    }

    public static JMLNode createSuperClassNode(JMLDocument jMLDocument, Class clazz) {
        JMLNode jMLNode = jMLDocument.createNode("super");
        if (clazz != null) {
            jMLNode.setAttribute("classname", clazz.getName());
        }
        return jMLNode;
    }

    public static JMLNode createPropertyNode(JMLDocument jMLDocument, String string, Object object) throws JMLException {
        JMLNode jMLNode = jMLDocument.createNode("at");
        jMLNode.setAttribute("name", string);
        if (object != null) {
            JMLSerializerFactory jMLSerializerFactory = JMLSerializerFactory.getInstance();
            JMLSerializer jMLSerializer = jMLSerializerFactory.createSerializer(object);
            if (jMLSerializer == null) {
                System.out.println("    xmlutils.createPropertyNode failed   propName: " + string + "  value: " + (object == null ? "NULL" : object.getClass().getName()));
                System.exit(0);
            }
            jMLNode.appendChild(jMLSerializer.serialize(jMLDocument, object));
            if (jMLSerializer instanceof InlineJMLSerializer) {
                jMLNode.setAttribute("object", ((InlineJMLSerializer)jMLSerializer).getObjectName());
            }
        }
        return jMLNode;
    }

    public static JMLNode createPropertiesNode(JMLDocument jMLDocument) {
        return jMLDocument.createNode("properties");
    }

    public static Object getPrimitiveHolder(Object object) {
        if (JMLUtils.isPrimitive(object)) {
            return new PrimitiveHolder(object);
        }
        return object;
    }

    public static SAXException createSAXException(String string) {
        return JMLUtils.createSAXException(string, null);
    }

    public static SAXException createSAXException(Exception exception) {
        return JMLUtils.createSAXException(null, exception);
    }

    public static SAXException createSAXException(String string, Exception exception) {
        if (exception instanceof SAXException) {
            return (SAXException)exception;
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (string != null) {
            stringBuffer.append(string);
        }
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        if (exception == null) {
            new Exception().printStackTrace(printWriter);
        } else {
            stringBuffer.append(exception.getMessage());
            exception.printStackTrace(printWriter);
        }
        stringBuffer.append("\n");
        stringBuffer.append(stringWriter.toString());
        stringBuffer.append("\n");
        if (exception == null) {
            return CustomSAXException.create(string, stringBuffer.toString());
        }
        return CustomSAXException.create(string, stringBuffer.toString());
    }

    public static boolean isPrimitive(Object object) {
        return object instanceof Byte || object instanceof Boolean || object instanceof Short || object instanceof Character || object instanceof Integer || object instanceof Float || object instanceof Double;
    }

    static {
        $assertionsDisabled = !JMLUtils.class.desiredAssertionStatus();
    }
}

