/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.domain.tasks.notification;

import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.xlrelease.builder.NotificationTaskBuilder;
import com.xebialabs.xlrelease.builder.TaskBuilder;
import com.xebialabs.xlrelease.domain.NotificationTask;
import com.xebialabs.xlrelease.domain.notification.MailPriority;
import com.xebialabs.xlrelease.views.TaskFullView;
import com.xebialabs.xlrelease.views.VariableOrPasswordView;
import com.xebialabs.xlrelease.views.converters.BaseTaskViewConverter;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class NotificationTaskViewConverter
extends BaseTaskViewConverter<NotificationTask> {
    @Override
    public TaskFullView toFullView(NotificationTask task, List<Type> allowedTaskTypesForAuthenticatedUser) {
        TaskFullView view = super.toFullView(task, allowedTaskTypesForAuthenticatedUser);
        view.setAddresses(task.getAddresses());
        view.setSubject(task.getSubject());
        view.setBody(task.getBody());
        view.setReplyTo(task.getReplyTo());
        view.setFrom(task.getFrom());
        view.setUsername(task.getSenderUsername());
        view.setPassword(new VariableOrPasswordView(task.getSenderPassword()));
        view.setBcc(task.getBcc());
        view.setCc(task.getCc());
        if (task.getPriority() != null) {
            view.setMailPriority(task.getPriority().getImportance().toLowerCase());
        }
        return view;
    }

    @Override
    protected NotificationTask fromView(TaskFullView view) {
        NotificationTaskBuilder builder = TaskBuilder.newNotificationTask().withAddresses(view.getAddresses()).withSubject(view.getSubject()).withBody(view.getBody()).withReplyTo(view.getReplyTo()).withFrom(view.getFrom()).withSenderUsername(view.getUsername()).withSenderPassword(view.getPassword().variableOrValue()).withMailPriority(MailPriority.fromString((String)view.getMailPriority()));
        if (view.getBcc() != null) {
            builder.withBcc(view.getBcc());
        }
        if (view.getCc() != null) {
            builder.withCc(view.getCc());
        }
        return builder.build();
    }

    @Override
    protected Class<NotificationTask> getTaskClass() {
        return NotificationTask.class;
    }
}

