/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.integration.phonehome;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class PhoneHomeResponse {
    private final Future<Boolean> phoneHomeTask;
    private final Boolean result;

    private PhoneHomeResponse(Future<Boolean> phoneHomeTask, Boolean result) {
        this.phoneHomeTask = phoneHomeTask;
        this.result = result;
    }

    public static PhoneHomeResponse createResponse(Boolean result) {
        return new PhoneHomeResponse(null, result);
    }

    public static PhoneHomeResponse createAsynchronousResponse(Future<Boolean> phoneHomeTask) {
        return new PhoneHomeResponse(phoneHomeTask, Boolean.FALSE);
    }

    public Boolean getImmediateResult() {
        return this.awaitResult(0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean awaitResult(long timeoutInSeconds) {
        if (this.phoneHomeTask != null) {
            try {
                Boolean bl = this.phoneHomeTask.get(timeoutInSeconds, TimeUnit.SECONDS);
                return bl;
            }
            catch (ExecutionException | TimeoutException e) {
                Boolean bl = Boolean.FALSE;
                return bl;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                Boolean bl = Boolean.FALSE;
                return bl;
            }
            finally {
                this.endPhoneHome();
            }
        }
        return this.result;
    }

    public boolean isDone() {
        if (this.phoneHomeTask != null) {
            return this.phoneHomeTask.isDone();
        }
        return true;
    }

    private boolean endPhoneHome() {
        if (this.phoneHomeTask != null && !this.phoneHomeTask.isDone()) {
            return this.phoneHomeTask.cancel(true);
        }
        return false;
    }
}

