/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.repository.sql;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.xlrelease.db.sql.transaction.IsTransactional;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.SecuredCis;
import com.xebialabs.xlrelease.repository.sql.persistence.FolderPersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.ReleasePersistence;
import com.xebialabs.xlrelease.repository.sql.persistence.data.FolderRow;
import com.xebialabs.xlrelease.security.SecuredCi;
import java.io.Serializable;
import scala.Function0;
import scala.Option;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.reflect.ScalaSignature;

@IsTransactional
@ScalaSignature(bytes="\u0006\u0005i4A\u0001C\u0005\u0001)!Aq\u0004\u0001B\u0001B\u0003%\u0001\u0005\u0003\u0005'\u0001\t\u0005\t\u0015!\u0003(\u0011\u0015Q\u0003\u0001\"\u0001,\u0011\u0015\u0001\u0004\u0001\"\u00112\u0011\u0015\u0001\u0006\u0001\"\u0011R\u0011\u0015!\u0006\u0001\"\u0003V\u0011\u0015!\u0007\u0001\"\u0011f\u00055\u0019\u0016\u000f\\*fGV\u0014X\rZ\"jg*\u0011!bC\u0001\u0004gFd'B\u0001\u0007\u000e\u0003)\u0011X\r]8tSR|'/\u001f\u0006\u0003\u001d=\t\u0011\u0002\u001f7sK2,\u0017m]3\u000b\u0005A\t\u0012!\u0003=fE&\fG.\u00192t\u0015\u0005\u0011\u0012aA2p[\u000e\u00011c\u0001\u0001\u00167A\u0011a#G\u0007\u0002/)\t\u0001$A\u0003tG\u0006d\u0017-\u0003\u0002\u001b/\t1\u0011I\\=SK\u001a\u0004\"\u0001H\u000f\u000e\u0003-I!AH\u0006\u0003\u0015M+7-\u001e:fI\u000eK7/A\tg_2$WM\u001d)feNL7\u000f^3oG\u0016\u0004\"!\t\u0013\u000e\u0003\tR!aI\u0005\u0002\u0017A,'o]5ti\u0016t7-Z\u0005\u0003K\t\u0012\u0011CR8mI\u0016\u0014\b+\u001a:tSN$XM\\2f\u0003I\u0011X\r\\3bg\u0016\u0004VM]:jgR,gnY3\u0011\u0005\u0005B\u0013BA\u0015#\u0005I\u0011V\r\\3bg\u0016\u0004VM]:jgR,gnY3\u0002\rqJg.\u001b;?)\racf\f\t\u0003[\u0001i\u0011!\u0003\u0005\u0006?\r\u0001\r\u0001\t\u0005\u0006M\r\u0001\raJ\u0001\u0016O\u0016$XI\u001a4fGRLg/Z*fGV\u0014X\rZ\"j)\t\u0011\u0004\b\u0005\u00024m5\tAG\u0003\u00026\u001b\u0005A1/Z2ve&$\u00180\u0003\u00028i\tI1+Z2ve\u0016$7)\u001b\u0005\u0006s\u0011\u0001\rAO\u0001\fG>tG/Y5oKJLE\r\u0005\u0002<\u0005:\u0011A\b\u0011\t\u0003{]i\u0011A\u0010\u0006\u0003\u007fM\ta\u0001\u0010:p_Rt\u0014BA!\u0018\u0003\u0019\u0001&/\u001a3fM&\u00111\t\u0012\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005\u0005;\u0002F\u0001\u0003G!\t9e*D\u0001I\u0015\tI%*\u0001\u0006b]:|G/\u0019;j_:T!a\u0013'\u0002\u000f5,GO]5dg*\u0011Q*E\u0001\tG>$\u0017\r[1mK&\u0011q\n\u0013\u0002\u0006)&lW\rZ\u0001\rO\u0016$8+Z2ve\u0016$7)\u001b\u000b\u0003eICQ!O\u0003A\u0002iB#!\u0002$\u0002\u0017\u0005\u001c8+Z2ve\u0016$7)\u001b\u000b\u0004eY;\u0006\"B\u001d\u0007\u0001\u0004Q\u0004\"\u0002-\u0007\u0001\u0004I\u0016aA;jIB\u0019aC\u0017/\n\u0005m;\"AB(qi&|g\u000e\u0005\u0002^E6\taL\u0003\u0002`A\u0006!A.\u00198h\u0015\u0005\t\u0017\u0001\u00026bm\u0006L!a\u00190\u0003\u000f%sG/Z4fe\u000692/\u001a;Bg\u00163g-Z2uSZ,7+Z2ve\u0016$7)\u001b\u000b\u0004M&T\u0007C\u0001\fh\u0013\tAwC\u0001\u0003V]&$\b\"B\u001d\b\u0001\u0004Q\u0004\"B6\b\u0001\u0004a\u0017aC5t\u000b\u001a4Wm\u0019;jm\u0016\u0004\"AF7\n\u00059<\"a\u0002\"p_2,\u0017M\u001c\u0015\u0003\u000f\u0019C#\u0001A9\u0011\u0005IDX\"A:\u000b\u0005Q,\u0018a\u0003;sC:\u001c\u0018m\u0019;j_:T!A\u0003<\u000b\u0005]l\u0011A\u00013c\u0013\tI8OA\bJgR\u0013\u0018M\\:bGRLwN\\1m\u0001")
public class SqlSecuredCis
implements SecuredCis {
    private final FolderPersistence folderPersistence;
    private final ReleasePersistence releasePersistence;

    @Timed
    public SecuredCi getEffectiveSecuredCi(String containerId) {
        String string = containerId;
        switch (string == null ? 0 : string.hashCode()) {
            default: 
        }
        if (Ids.isFolderId((String)string)) {
            return this.folderPersistence.getEffectiveSecuredCi(string);
        }
        if (Ids.isReleaseId((String)string)) {
            return this.releasePersistence.getEffectiveSecuredCi(string);
        }
        return this.getSecuredCi(string);
    }

    @Timed
    public SecuredCi getSecuredCi(String containerId) {
        String string = containerId;
        switch (string == null ? 0 : string.hashCode()) {
            default: 
        }
        if (Ids.isFolderId((String)string)) {
            return this.folderPersistence.getSecuredCi(containerId);
        }
        if (Ids.isReleaseId((String)string)) {
            return this.asSecuredCi(string, this.releasePersistence.findUidByReleaseId(string));
        }
        throw new IllegalArgumentException(new StringBuilder(46).append("Unable to get UID for unsupported ID format [").append(containerId).append("]").toString());
    }

    private SecuredCi asSecuredCi(String containerId, Option<Integer> uid) {
        return new SecuredCi(containerId, ((Integer)uid.getOrElse((Function0 & Serializable)() -> {
            throw new IllegalArgumentException(new StringBuilder(31).append("Unable to find release by ID [").append(containerId).append("]").toString());
        })).toString());
    }

    @Timed
    public void setAsEffectiveSecuredCi(String containerId, boolean isEffective) {
        if (Ids.isFolderId((String)containerId)) {
            int oldSecurityUid = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(this.folderPersistence.getEffectiveSecuredCi(containerId).getSecurityUid()));
            FolderRow newFolderData = isEffective ? this.folderPersistence.setAsEffectiveSecuredCi(containerId) : this.folderPersistence.inheritEffectiveSecuredCi(containerId);
            this.releasePersistence.replaceSecurityUid(newFolderData.uid(), Predef$.MODULE$.int2Integer(oldSecurityUid), newFolderData.securityUid());
            return;
        }
        if (isEffective) {
            this.releasePersistence.setAsEffectiveSecuredCi(containerId);
            return;
        }
        SecuredCi effectiveFolder = this.folderPersistence.getEffectiveSecuredCi(Ids.getParentId((String)containerId));
        this.releasePersistence.inheritSecurityFromFolder(containerId, Predef$.MODULE$.int2Integer(StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(effectiveFolder.getSecurityUid()))));
    }

    public SqlSecuredCis(FolderPersistence folderPersistence, ReleasePersistence releasePersistence) {
        this.folderPersistence = folderPersistence;
        this.releasePersistence = releasePersistence;
    }
}

