/*
 * Decompiled with CFR 0.152.
 */
package com.ryantenney.metrics.spring;

import com.ryantenney.metrics.spring.AnnotationFilter;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.util.ReflectionUtils;

abstract class AbstractAnnotationBeanPostProcessor
implements BeanPostProcessor {
    protected final Logger LOG = LoggerFactory.getLogger(this.getClass());
    private final Members members;
    private final Phase phase;
    private final AnnotationFilter filter;

    public AbstractAnnotationBeanPostProcessor(Members members, Phase phase, AnnotationFilter filter) {
        this.members = members;
        this.phase = phase;
        this.filter = filter;
    }

    protected void withField(Object bean, String beanName, Class<?> targetClass, Field field) {
    }

    protected void withMethod(Object bean, String beanName, Class<?> targetClass, Method method) {
    }

    public final Object postProcessBeforeInitialization(Object bean, String beanName) {
        if (this.phase == Phase.PRE_INIT) {
            this.process(bean, beanName);
        }
        return bean;
    }

    public final Object postProcessAfterInitialization(Object bean, String beanName) {
        if (this.phase == Phase.POST_INIT) {
            this.process(bean, beanName);
        }
        return bean;
    }

    private void process(final Object bean, final String beanName) {
        final Class targetClass = AopUtils.getTargetClass((Object)bean);
        if (this.members == Members.FIELDS || this.members == Members.ALL) {
            ReflectionUtils.doWithFields((Class)targetClass, (ReflectionUtils.FieldCallback)new ReflectionUtils.FieldCallback(){

                public void doWith(Field field) throws IllegalAccessException {
                    AbstractAnnotationBeanPostProcessor.this.withField(bean, beanName, targetClass, field);
                }
            }, (ReflectionUtils.FieldFilter)this.filter);
        }
        if (this.members == Members.METHODS || this.members == Members.ALL) {
            ReflectionUtils.doWithMethods((Class)targetClass, (ReflectionUtils.MethodCallback)new ReflectionUtils.MethodCallback(){

                public void doWith(Method method) throws IllegalAccessException {
                    AbstractAnnotationBeanPostProcessor.this.withMethod(bean, beanName, targetClass, method);
                }
            }, (ReflectionUtils.MethodFilter)this.filter);
        }
    }

    public static enum Phase {
        PRE_INIT,
        POST_INIT;

    }

    public static enum Members {
        FIELDS,
        METHODS,
        ALL;

    }
}

