/*
 * Decompiled with CFR 0.152.
 */
package org.prevayler.implementation.publishing;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.prevayler.Clock;
import org.prevayler.implementation.TransactionTimestamp;
import org.prevayler.implementation.publishing.TransactionPublisher;
import org.prevayler.implementation.publishing.TransactionSubscriber;

public abstract class AbstractPublisher
implements TransactionPublisher {
    protected final Clock _clock;
    private final List _subscribers = new LinkedList();

    public AbstractPublisher(Clock clock) {
        this._clock = clock;
    }

    @Override
    public Clock clock() {
        return this._clock;
    }

    public synchronized void addSubscriber(TransactionSubscriber subscriber) {
        this._subscribers.add(subscriber);
    }

    @Override
    public synchronized void cancelSubscription(TransactionSubscriber subscriber) {
        this._subscribers.remove(subscriber);
    }

    protected synchronized void notifySubscribers(TransactionTimestamp transactionTimestamp) {
        Iterator i = this._subscribers.iterator();
        while (i.hasNext()) {
            ((TransactionSubscriber)i.next()).receive(transactionTimestamp);
        }
    }
}

