/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service;

import com.codahale.metrics.annotation.Timed;
import com.xebialabs.deployit.exception.NotFoundException;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.service.ReleaseService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ReleaseTitleResolver {
    private static final Logger logger = LoggerFactory.getLogger(ReleaseTitleResolver.class);
    private ReleaseService releaseService;

    @Autowired
    public ReleaseTitleResolver(ReleaseService releaseService) {
        this.releaseService = releaseService;
    }

    @Timed
    public String getReleaseTitleFromChild(String childId) {
        if (childId == null) {
            return null;
        }
        return this.getReleaseTitle(Ids.releaseIdFrom((String)childId));
    }

    @Timed
    public String getReleaseTitle(String id) {
        if (id == null) {
            return null;
        }
        String title = null;
        try {
            title = this.releaseService.getTitle(id);
        }
        catch (NotFoundException e) {
            logger.warn("Could not find release with ID {} to resolve its title", (Object)id);
        }
        return title;
    }
}

